/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.tabs;

import de.markusbordihn.easymobfarm.capture.MobCaptureManager;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureCardDefinitionManager;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureData;
import de.markusbordihn.easymobfarm.data.capture.MobColor;
import de.markusbordihn.easymobfarm.item.mobcapturecard.MobCaptureCardItem;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1935;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomMobCaptureCards {
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");

    private CustomMobCaptureCards() {
    }

    public static Set<class_1799> getCustomMobCaptureCards(class_1935 mobCaptureCardItem) {
        if (!(mobCaptureCardItem instanceof MobCaptureCardItem)) {
            return Collections.emptySet();
        }
        LinkedHashSet<class_1799> result = new LinkedHashSet<class_1799>();
        result.add(MobCaptureManager.createMobCaptureCard(mobCaptureCardItem, new MobCaptureData("Common Card", class_1299.field_6131, class_1814.field_8906)));
        result.add(MobCaptureManager.createMobCaptureCard(mobCaptureCardItem, new MobCaptureData("Uncommon Card", class_1299.field_6131, class_1814.field_8907)));
        result.add(MobCaptureManager.createMobCaptureCard(mobCaptureCardItem, new MobCaptureData("Rare Card", class_1299.field_6131, class_1814.field_8903)));
        result.add(MobCaptureManager.createMobCaptureCard(mobCaptureCardItem, new MobCaptureData("Epic Card", class_1299.field_6131, class_1814.field_8904)));
        MobCaptureCardDefinitionManager.getAll().forEach((location, definition) -> {
            if (definition == null || definition.entityType() == null || definition.model() == null) {
                return;
            }
            class_1799 itemStack = MobCaptureManager.createMobCaptureCard(mobCaptureCardItem, definition.entityType());
            if (itemStack != null && !itemStack.method_7960()) {
                result.add(itemStack);
            }
            definition.variants().forEach((variantName, variant) -> {
                if (variant == null) {
                    return;
                }
                class_1799 variantItemStack = MobCaptureManager.createMobCaptureCard(mobCaptureCardItem, definition.entityType(), variantName, null);
                if (variantItemStack != null && !variantItemStack.method_7960()) {
                    result.add(variantItemStack);
                }
            });
            definition.colors().forEach((colorName, color) -> {
                if (color == null) {
                    return;
                }
                class_1799 colorItemStack = MobCaptureManager.createMobCaptureCard(mobCaptureCardItem, definition.entityType(), null, MobColor.valueOf(colorName.toUpperCase(Locale.ROOT)));
                if (colorItemStack != null && !colorItemStack.method_7960()) {
                    result.add(colorItemStack);
                }
            });
        });
        return result;
    }
}

