/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.capture;

import de.markusbordihn.easymobfarm.component.DataComponents;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureData;
import de.markusbordihn.easymobfarm.data.capture.MobColor;
import de.markusbordihn.easymobfarm.data.capture.MobEntityData;
import de.markusbordihn.easymobfarm.item.mobcapturecard.MobCaptureCardItem;
import net.minecraft.class_11352;
import net.minecraft.class_11368;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MobCaptureManager {
    public static final String COLOR_TAG = "Color";
    public static final String VARIANT_TAG = "variant";
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private static final String LOG_PREFIX = "[MobCaptureManager]";

    private MobCaptureManager() {
    }

    public static class_1799 getMobCaptureCardItem(class_1299<?> entityType, class_1937 level) {
        if (entityType == null || level == null) {
            return null;
        }
        class_1297 entity = entityType.method_5883(level, class_3730.field_16465);
        if (entity == null) {
            log.error("{} Unable to create entity {}!", (Object)LOG_PREFIX, entityType);
            return null;
        }
        if (!(entity instanceof class_1309)) {
            log.error("{} Entity {} is not a living entity!", (Object)LOG_PREFIX, entityType);
            entity.method_31472();
            return null;
        }
        class_1309 livingEntity = (class_1309)entity;
        class_1799 itemStack = MobCaptureManager.getMobCaptureCardItem(livingEntity);
        log.debug("{} Captured mob {} with data:{}.", (Object)LOG_PREFIX, entityType, (Object)itemStack);
        entity.method_31472();
        return itemStack;
    }

    public static class_1799 getMobCaptureCardItem(class_1309 livingEntity) {
        if (livingEntity == null || livingEntity instanceof class_1657 || livingEntity.method_37908().field_9236) {
            return null;
        }
        MobCaptureCardItem mobCaptureCardItem = MobCaptureCardItem.getMobCaptureCardItem();
        if (mobCaptureCardItem == null) {
            log.error("{} Unable to find mob capture card item!", (Object)LOG_PREFIX);
            return null;
        }
        MobCaptureData mobCaptureData = new MobCaptureData(livingEntity);
        if (mobCaptureData.entityType() == null || mobCaptureData.data() == null) {
            log.debug("{} Unable to get mob capture data from living entity {}.", (Object)LOG_PREFIX, (Object)livingEntity);
            return null;
        }
        mobCaptureData = mobCaptureData.withData(MobEntityData.removeSafeToRemoveMobCaptureCardTags(mobCaptureData.data()));
        class_1799 itemStack = new class_1799((class_1935)mobCaptureCardItem);
        MobCaptureManager.writeMobCaptureData(itemStack, mobCaptureData);
        log.debug("{} Captured mob {} with data:{}", (Object)LOG_PREFIX, mobCaptureData.entityType(), (Object)mobCaptureData.data());
        return itemStack;
    }

    public static boolean releaseMob(MobCaptureData mobCaptureData, class_2338 blockPos, class_3218 serverLevel) {
        if (mobCaptureData == null || mobCaptureData.entityType() == null) {
            return false;
        }
        class_1299<?> entityType = mobCaptureData.entityType();
        if (entityType == null) {
            return false;
        }
        class_1297 entity = entityType.method_5883((class_1937)serverLevel, class_3730.field_16465);
        if (entity == null) {
            log.error("{} Unable to create entity {}!", (Object)LOG_PREFIX, entityType);
            return false;
        }
        class_2487 mobDataTag = mobCaptureData.data();
        class_11368 valueInput = class_11352.method_71417((class_8942)class_8942.field_60348, (class_7225.class_7874)entity.method_37908().method_30349(), (class_2487)mobDataTag);
        entity.method_5651(valueInput);
        class_2338 safeSpawnBlockPos = MobCaptureManager.getSafeSpawnPos((class_1937)serverLevel, blockPos);
        if (safeSpawnBlockPos == null) {
            log.warn("{} Unable to release mob {} with data:{} at block position {}.", (Object)LOG_PREFIX, entityType, (Object)mobCaptureData.data(), (Object)blockPos);
            return false;
        }
        entity.method_5808((double)safeSpawnBlockPos.method_10263() + 0.5, (double)safeSpawnBlockPos.method_10264() + 1.0, (double)safeSpawnBlockPos.method_10260() + 0.5, 0.0f, 0.0f);
        serverLevel.method_8649(entity);
        log.debug("{} Released mob {} with data:{} at block position {}.", (Object)LOG_PREFIX, entityType, (Object)mobCaptureData.data(), (Object)safeSpawnBlockPos);
        return true;
    }

    public static class_1799 createMobCaptureCard(class_1935 itemLike, class_1299<?> entityType) {
        if (itemLike == null || entityType == null) {
            return null;
        }
        return MobCaptureManager.createMobCaptureCard(itemLike, new MobCaptureData(entityType).withFoil(false));
    }

    public static class_1799 createMobCaptureCard(class_1935 itemLike, MobCaptureData mobCaptureData) {
        if (itemLike == null) {
            return null;
        }
        class_1799 itemStack = new class_1799(itemLike);
        MobCaptureManager.writeMobCaptureData(itemStack, mobCaptureData);
        return itemStack;
    }

    public static class_1799 createMobCaptureCard(class_1935 itemLike, class_1299<?> entityType, String variant, MobColor mobColor) {
        if (itemLike == null || entityType == null) {
            return null;
        }
        MobCaptureData mobCaptureData = new MobCaptureData(entityType).withFoil(false);
        class_2487 compoundTag = new class_2487();
        if (variant != null && !variant.isEmpty()) {
            mobCaptureData = mobCaptureData.withVariant(variant);
            if (entityType == class_1299.field_16281 || entityType == class_1299.field_37419) {
                compoundTag.method_10582(VARIANT_TAG, variant);
            }
        }
        if (mobColor != null && mobColor != MobColor.NONE) {
            mobCaptureData = mobCaptureData.withColor(mobColor);
            compoundTag.method_10569(COLOR_TAG, mobColor.getDyeColor().method_7789());
        }
        return MobCaptureManager.createMobCaptureCard(itemLike, mobCaptureData.withData(compoundTag));
    }

    public static void writeMobCaptureData(class_1799 itemStack, MobCaptureData mobCaptureData) {
        if (itemStack == null || itemStack.method_7960() || mobCaptureData == null) {
            return;
        }
        itemStack.method_57379(DataComponents.MOB_CAPTURE_DATA, (Object)mobCaptureData);
    }

    public static boolean hasMobCaptureData(class_1799 itemStack) {
        return itemStack != null && !itemStack.method_7960() && itemStack.method_57826(DataComponents.MOB_CAPTURE_DATA) && !((MobCaptureData)itemStack.method_58695(DataComponents.MOB_CAPTURE_DATA, (Object)MobCaptureData.EMPTY)).isEmpty();
    }

    public static MobCaptureData getMobCaptureData(class_1799 itemStack, class_1937 level) {
        if (itemStack == null || itemStack.method_7960()) {
            return null;
        }
        if (itemStack.method_57826(DataComponents.MOB_CAPTURE_DATA)) {
            return (MobCaptureData)itemStack.method_58694(DataComponents.MOB_CAPTURE_DATA);
        }
        return new MobCaptureData(itemStack, ((class_9279)itemStack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302)).method_57463(), level);
    }

    public static boolean isSafeSpawnPos(class_1937 level, class_2338 blockPos) {
        class_2680 surfaceState = level.method_8320(blockPos.method_10074());
        class_2680 groundState = level.method_8320(blockPos.method_10087(2));
        class_265 surfaceShape = surfaceState.method_26220((class_1922)level, blockPos.method_10074());
        class_265 groundShape = groundState.method_26220((class_1922)level, blockPos.method_10087(2));
        double surfaceHeight = surfaceShape.method_1110() ? 0.0 : surfaceShape.method_1107().field_1325;
        double groundHeight = groundShape.method_1110() ? 0.0 : groundShape.method_1107().field_1325;
        return (!surfaceState.method_26215() || !(surfaceHeight < 0.05)) && !groundState.method_26215() && groundHeight >= 0.5;
    }

    public static class_2338 getSafeSpawnPos(class_1937 level, class_2338 blockPos) {
        if (MobCaptureManager.isSafeSpawnPos(level, blockPos)) {
            return blockPos;
        }
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                class_2338 nearbyPos;
                if (dx == 0 && dz == 0 || !MobCaptureManager.isSafeSpawnPos(level, nearbyPos = blockPos.method_10069(dx, 0, dz))) continue;
                return nearbyPos;
            }
        }
        return null;
    }
}

