/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.markusbordihn.easymobfarm.block.entity.MobFarmBlockEntity;
import de.markusbordihn.easymobfarm.component.DataComponents;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmData;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmType;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2464;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3620;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_9904;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MobFarmBlock
extends class_2237 {
    public static final class_2754<class_2350> FACING = class_2383.field_11177;
    public static final class_2746 WORKING = class_2746.method_11825((String)"working");
    public static final class_2758 TIER_LEVEL = class_2758.method_11867((String)"tier_level", (int)0, (int)3);
    public static final class_2746 POWERED = class_2746.method_11825((String)"powered");
    public static final class_2754<MobFarmType> FARM_TYPE = class_2754.method_11850((String)"farm_type", MobFarmType.class);
    public static final MapCodec<MobFarmBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MobFarmType.CODEC.fieldOf("mobFarmType").forGetter(block -> MobFarmBlock.getFarmType(block.method_9564()))).apply((Applicative)instance, MobFarmBlock::new));
    protected static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");

    public MobFarmBlock(MobFarmType mobFarmType) {
        this(class_4970.class_2251.method_9637().method_63500(class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60655((String)"easy_mob_farm", (String)mobFarmType.getId()))).method_31710(class_3620.field_16023).method_29292().method_9632(5.0f).method_9631(MobFarmBlock::getLightLevel).method_9626(class_2498.field_11533).method_22488(), mobFarmType);
    }

    public MobFarmBlock(class_4970.class_2251 properties, MobFarmType mobFarmType) {
        this(properties, 0, mobFarmType);
    }

    public MobFarmBlock(class_4970.class_2251 properties, int tierLevel, MobFarmType mobFarmType) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)WORKING, (Comparable)Boolean.FALSE)).method_11657((class_2769)TIER_LEVEL, (Comparable)Integer.valueOf(tierLevel))).method_11657(FARM_TYPE, (Comparable)((Object)mobFarmType))).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public static int getLightLevel(class_2680 blockState) {
        return Boolean.TRUE.equals(blockState.method_11654((class_2769)WORKING)) ? 15 : 8;
    }

    public static int getTierLevel(class_2680 blockState) {
        return (Integer)blockState.method_11654((class_2769)TIER_LEVEL);
    }

    public static MobFarmType getFarmType(class_2680 blockState) {
        return (MobFarmType)((Object)blockState.method_11654(FARM_TYPE));
    }

    public class_2586 newBlockEntity(class_2338 blockPos, class_2680 blockState, MobFarmType mobFarmType) {
        throw new UnsupportedOperationException("This method must be overridden by a subclass!");
    }

    protected MapCodec<? extends class_2237> method_53969() {
        return CODEC;
    }

    public void method_9536(class_2680 state, class_1937 level, class_2338 blockPos, class_2680 newState, boolean isMoving) {
        if (!state.method_27852(newState.method_26204())) {
            class_2586 blockEntity = level.method_8321(blockPos);
            if (blockEntity instanceof MobFarmBlockEntity) {
                MobFarmBlockEntity mobFarmBlockEntity = (MobFarmBlockEntity)blockEntity;
                mobFarmBlockEntity.dropInventoryContents();
                level.method_8455(blockPos, (class_2248)this);
            }
            super.method_9536(state, level, blockPos, newState, isMoving);
        }
    }

    public class_2586 method_10123(class_2338 blockPos, class_2680 blockState) {
        return this.newBlockEntity(blockPos, blockState, MobFarmBlock.getFarmType(blockState));
    }

    public class_2464 method_9604(class_2680 blockState) {
        return class_2464.field_11458;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> blockState) {
        blockState.method_11667(new class_2769[]{FACING, WORKING, TIER_LEVEL, FARM_TYPE, POWERED});
    }

    public class_2680 method_9605(class_1750 context) {
        return (class_2680)this.method_9564().method_11657(FACING, (Comparable)context.method_8042().method_10153());
    }

    public void method_9567(class_1937 level, class_2338 blockPos, class_2680 blockState, class_1309 livingEntity, class_1799 itemStack) {
        class_2586 blockEntity = level.method_8321(blockPos);
        if (blockEntity instanceof MobFarmBlockEntity) {
            MobFarmBlockEntity blockEntityInstance = (MobFarmBlockEntity)blockEntity;
            if (level instanceof class_3218) {
                boolean powered;
                class_3218 serverLevel = (class_3218)level;
                if (livingEntity instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)livingEntity;
                    blockEntityInstance.setOwner((class_1657)serverPlayer);
                }
                class_2680 newBlockState = blockState;
                MobFarmData mobFarmData = (MobFarmData)itemStack.method_57825(DataComponents.MOB_FARM_DATA, (Object)MobFarmData.EMPTY);
                int tierLevel = mobFarmData.tierLevel().getTierLevel();
                if (tierLevel >= 0) {
                    newBlockState = (class_2680)newBlockState.method_11657((class_2769)TIER_LEVEL, (Comparable)Integer.valueOf(tierLevel));
                    blockEntityInstance.setFarmTierLevel(tierLevel);
                }
                if ((powered = level.method_49803(blockPos)) != Boolean.TRUE.equals(blockState.method_11654((class_2769)POWERED))) {
                    newBlockState = (class_2680)newBlockState.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(powered));
                }
                if (!newBlockState.equals(blockState)) {
                    serverLevel.method_8652(blockPos, newBlockState, 3);
                    blockEntity.method_5431();
                }
            }
        }
    }

    protected class_1269 method_55766(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player, class_3965 hitResult) {
        if (level.field_9236) {
            return class_1269.field_5812;
        }
        this.openMenu(level, blockPos, player);
        return class_1269.field_21466;
    }

    public class_1269 method_55765(class_1799 itemStack, class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player, class_1268 interactionHand, class_3965 blockHitResult) {
        if (level.field_9236) {
            return class_1269.field_5812;
        }
        class_2586 blockEntity = level.method_8321(blockPos);
        if (!(blockEntity instanceof MobFarmBlockEntity)) {
            return class_1269.field_5814;
        }
        MobFarmBlockEntity mobFarmBlockEntity = (MobFarmBlockEntity)blockEntity;
        if (!itemStack.method_7960() && (mobFarmBlockEntity.takeMobCaptureItem(player, interactionHand) || mobFarmBlockEntity.takeEnhancementItem(player, interactionHand) || mobFarmBlockEntity.takeSlotUpgradeItem(player, interactionHand) || mobFarmBlockEntity.takeFilterItem(player, interactionHand))) {
            return class_1269.field_21466;
        }
        if (player.method_5715() && mobFarmBlockEntity.hasCapturedMob()) {
            mobFarmBlockEntity.giveMobCaptureItem(player, interactionHand);
            return class_1269.field_21466;
        }
        this.openMenu(level, blockPos, player);
        return class_1269.field_21466;
    }

    public void method_9612(class_2680 blockState, class_1937 level, class_2338 blockPos, class_2248 block, class_9904 orientation, boolean isMoving) {
        boolean isPoweredNow;
        boolean isPowered;
        if (!level.field_9236 && (isPowered = ((Boolean)blockState.method_11654((class_2769)POWERED)).booleanValue()) != (isPoweredNow = level.method_49803(blockPos))) {
            level.method_8652(blockPos, (class_2680)blockState.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(isPoweredNow)), 2);
        }
    }

    protected void openMenu(class_1937 level, class_2338 blockPos, class_1657 player) {
        class_2586 blockEntity = level.method_8321(blockPos);
        if (blockEntity instanceof MobFarmBlockEntity) {
            MobFarmBlockEntity blockEntityInstance = (MobFarmBlockEntity)blockEntity;
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                serverPlayer.method_17355((class_3908)blockEntityInstance);
            }
        }
    }
}

