/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.client.renderer.blockentity;

import de.markusbordihn.easymobfarm.block.MobFarmBlock;
import de.markusbordihn.easymobfarm.block.entity.MobFarmBlockEntity;
import de.markusbordihn.easymobfarm.client.renderer.manager.EntityScalingManager;
import de.markusbordihn.easymobfarm.client.renderer.manager.RendererManager;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureCardDefinition;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureCardDefinitionManager;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmType;
import net.minecraft.class_10017;
import net.minecraft.class_10042;
import net.minecraft.class_1297;
import net.minecraft.class_1307;
import net.minecraft.class_1309;
import net.minecraft.class_1425;
import net.minecraft.class_1432;
import net.minecraft.class_1477;
import net.minecraft.class_1510;
import net.minecraft.class_1577;
import net.minecraft.class_1593;
import net.minecraft.class_2350;
import net.minecraft.class_310;
import net.minecraft.class_4466;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import net.minecraft.class_897;
import net.minecraft.class_898;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MobFarmBlockEntityRenderer<T extends MobFarmBlockEntity>
implements class_827<T> {
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");

    public MobFarmBlockEntityRenderer(class_5614.class_5615 context) {
    }

    public void render(T blockEntity, float partialTicks, class_4587 poseStack, class_4597 buffer, int combinedLight, int combinedOverlay) {
        if (!((MobFarmBlockEntity)((Object)blockEntity)).hasCapturedMob()) {
            RendererManager.removeEntity(blockEntity);
            return;
        }
        class_1297 entity = RendererManager.getOrCreateEntity(blockEntity);
        if (entity == null) {
            return;
        }
        try {
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                this.renderLivingEntity(blockEntity, livingEntity, poseStack, buffer, combinedLight);
            } else if (entity instanceof class_1297) {
                this.renderGenericEntity(blockEntity, entity, poseStack, buffer, combinedLight);
            }
        }
        catch (Exception livingException) {
            try {
                this.renderGenericEntity(blockEntity, entity, poseStack, buffer, combinedLight);
            }
            catch (Exception genericException) {
                log.error("Failed to render entity {} for block entity {} with exception: {}", (Object)entity.method_5864(), (Object)blockEntity.method_11016(), (Object)genericException.getMessage());
            }
        }
    }

    private void renderLivingEntity(T blockEntity, class_1309 entity, class_4587 poseStack, class_4597 buffer, int combinedLight) {
        class_898 dispatcher = class_310.method_1551().method_1561();
        class_897 renderer = dispatcher.method_3953((class_1297)entity);
        class_10042 state = (class_10042)renderer.method_62425((class_1297)entity, 0.0f);
        entity.field_6012 = (int)blockEntity.method_10997().method_8510();
        MobCaptureCardDefinition mobCaptureCardDefinition = MobCaptureCardDefinitionManager.get(entity.method_5864());
        if (mobCaptureCardDefinition != null && mobCaptureCardDefinition.requiresAnimationTick() && entity.field_6012 % 2 == 0) {
            entity.method_5773();
        }
        poseStack.method_22903();
        this.prepareEntityPose(blockEntity, (class_1297)entity, poseStack);
        renderer.method_3936((class_10017)state, poseStack, buffer, combinedLight);
        poseStack.method_22909();
    }

    private void renderGenericEntity(T blockEntity, class_1297 entity, class_4587 poseStack, class_4597 buffer, int combinedLight) {
        class_898 dispatcher = class_310.method_1551().method_1561();
        class_897 renderer = dispatcher.method_3953(entity);
        class_10017 stateRaw = renderer.method_62425(entity, 0.0f);
        if (!(stateRaw instanceof class_10017)) {
            return;
        }
        class_10017 state = stateRaw;
        entity.field_6012 = (int)blockEntity.method_10997().method_8510();
        poseStack.method_22903();
        this.prepareEntityPose(blockEntity, entity, poseStack);
        renderer.method_3936(state, poseStack, buffer, combinedLight);
        poseStack.method_22909();
    }

    private void prepareEntityPose(T blockEntity, class_1297 entity, class_4587 poseStack) {
        class_1432 flyingAnimal;
        MobFarmType mobFarmType = ((MobFarmBlockEntity)((Object)blockEntity)).getFarmType();
        if (mobFarmType == MobFarmType.LUCKY_DROP_FARM) {
            poseStack.method_22904(0.5, 0.19, 0.5);
        } else {
            poseStack.method_22904(0.5, 0.08, 0.5);
        }
        float entityScaling = EntityScalingManager.getEntityScale(entity);
        if (mobFarmType == MobFarmType.LUCKY_DROP_FARM) {
            entityScaling *= 0.75f;
        }
        poseStack.method_22905(entityScaling, entityScaling, entityScaling);
        float rotationDegrees = switch ((class_2350)blockEntity.method_11010().method_11654(MobFarmBlock.FACING)) {
            case class_2350.field_11043 -> 180.0f;
            case class_2350.field_11035 -> 0.0f;
            case class_2350.field_11039 -> -90.0f;
            case class_2350.field_11034 -> 90.0f;
            default -> 0.0f;
        };
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(rotationDegrees));
        if (entity instanceof class_1425) {
            poseStack.method_22904(-0.1, 0.5, 0.1);
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(2.0f));
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(15.0f));
            poseStack.method_22907(class_7833.field_40718.rotationDegrees(-90.0f));
        } else if (entity instanceof class_4466) {
            poseStack.method_22904(0.0, 0.5, 0.0);
        } else if (entity instanceof class_1477) {
            poseStack.method_22904(0.0, 1.3, 0.0);
        } else if (entity instanceof class_1593) {
            poseStack.method_22904(0.0, 0.5, 0.0);
        } else if (entity instanceof class_1307 || entity instanceof class_1432 && (flyingAnimal = (class_1432)entity).method_6581() || entity instanceof class_1577) {
            poseStack.method_22904(0.0, 0.3 / (double)entityScaling, 0.0);
        } else if (entity instanceof class_1510) {
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(0.0f));
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
            poseStack.method_22907(class_7833.field_40718.rotationDegrees(0.0f));
        }
    }
}

