/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.data.capture;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.markusbordihn.easymobfarm.data.capture.MobColor;
import de.markusbordihn.easymobfarm.data.capture.MobColorData;
import de.markusbordihn.easymobfarm.data.capture.MobEntityData;
import de.markusbordihn.easymobfarm.data.capture.MobEntityTypeData;
import de.markusbordihn.easymobfarm.data.capture.MobFoilData;
import de.markusbordihn.easymobfarm.data.capture.MobNameData;
import de.markusbordihn.easymobfarm.data.capture.MobRarityData;
import de.markusbordihn.easymobfarm.data.capture.MobVariantData;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record MobCaptureData(String name, String type, class_1299<?> entityType, class_2487 data, MobColor color, String variant, class_1814 rarity, boolean isFoil) {
    public static final String ID = "mob_capture_data";
    public static final String TYPE_SEPARATOR = ":";
    public static final MobCaptureData EMPTY = new MobCaptureData("", "", class_1299.field_6131, new class_2487(), MobColor.NONE, "", class_1814.field_8906, false);
    public static final Codec<MobCaptureData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(MobCaptureData::name), (App)Codec.STRING.fieldOf("type").forGetter(MobCaptureData::type), (App)class_7923.field_41177.method_39673().fieldOf("entityType").forGetter(MobCaptureData::entityType), (App)class_2487.field_25128.optionalFieldOf("data", (Object)new class_2487()).forGetter(MobCaptureData::data), (App)MobColor.CODEC.optionalFieldOf("color", (Object)MobColor.NONE).forGetter(MobCaptureData::color), (App)Codec.STRING.optionalFieldOf("variant", (Object)"").forGetter(MobCaptureData::variant), (App)class_1814.field_50001.optionalFieldOf("rarity", (Object)class_1814.field_8906).forGetter(MobCaptureData::rarity), (App)Codec.BOOL.optionalFieldOf("isFoil", (Object)false).forGetter(MobCaptureData::isFoil)).apply((Applicative)instance, MobCaptureData::new));
    public static final class_9139<class_9129, MobCaptureData> STREAM_CODEC = class_9139.method_65036((class_9139)class_9135.field_48554, MobCaptureData::name, (class_9139)class_9135.field_48554, MobCaptureData::type, (class_9139)class_9135.method_56365((class_5321)class_7924.field_41266), MobCaptureData::entityType, (class_9139)class_9135.field_48556, MobCaptureData::data, MobColor.STREAM_CODEC, MobCaptureData::color, (class_9139)class_9135.field_48554, MobCaptureData::variant, (class_9139)class_1814.field_50003, MobCaptureData::rarity, (class_9139)class_9135.field_48547, MobCaptureData::isFoil, MobCaptureData::new);
    private static final int MAX_ID_LIMIT = 0x1000000;

    public MobCaptureData(String name, class_1299<?> entityType, class_1814 rarity) {
        this(name, MobEntityTypeData.getEntityTypeName(entityType), MobEntityTypeData.getEntityType(entityType), MobEntityData.getMobEntityData(entityType), MobColorData.getColor(entityType), MobVariantData.getVariant(entityType), rarity, MobFoilData.getRandomFoil());
    }

    public MobCaptureData(class_1299<?> entityType) {
        this(MobNameData.getName(entityType), MobEntityTypeData.getEntityTypeName(entityType), MobEntityTypeData.getEntityType(entityType), MobEntityData.getMobEntityData(entityType), MobColorData.getColor(entityType), MobVariantData.getVariant(entityType), MobRarityData.getRarity(entityType), MobFoilData.getRandomFoil());
    }

    public MobCaptureData(class_1309 livingEntity) {
        this(MobNameData.getName(livingEntity), MobEntityTypeData.getEntityTypeName(livingEntity), MobEntityTypeData.getEntityType(livingEntity), MobEntityData.getMobEntityData(livingEntity), MobColorData.getColor(livingEntity), MobVariantData.getVariant(livingEntity), MobRarityData.getRarity(livingEntity), MobFoilData.getRandomFoil());
    }

    public MobCaptureData(class_1799 itemStack, class_2487 compoundTag, class_1937 level) {
        this(MobNameData.getName(compoundTag), MobEntityTypeData.getEntityTypeName(itemStack, compoundTag, level), MobEntityTypeData.getEntityType(itemStack, compoundTag, level), MobEntityData.getMobEntityData(compoundTag), MobColorData.getColor(compoundTag), MobVariantData.getVariant(compoundTag), MobRarityData.getRarity(compoundTag), MobFoilData.getFoil(compoundTag));
    }

    public MobCaptureData(class_1799 itemStack, class_2487 compoundTag) {
        this(MobNameData.getName(compoundTag), MobEntityTypeData.getEntityTypeName(itemStack, compoundTag, null), MobEntityTypeData.getEntityType(itemStack, compoundTag, null), MobEntityData.getMobEntityData(compoundTag), MobColorData.getColor(compoundTag), MobVariantData.getVariant(compoundTag), MobRarityData.getRarity(compoundTag), MobFoilData.getFoil(compoundTag));
    }

    public MobCaptureData(class_2487 compoundTag) {
        this(MobNameData.getName(compoundTag), MobEntityTypeData.getEntityTypeName(compoundTag), MobEntityTypeData.getEntityType(compoundTag), MobEntityData.getMobEntityData(compoundTag), MobColorData.getColor(compoundTag), MobVariantData.getVariant(compoundTag), MobRarityData.getRarity(compoundTag), MobFoilData.getFoil(compoundTag));
    }

    public int getCardId() {
        int namespaceHash = this.type != null && this.type.contains(TYPE_SEPARATOR) ? this.type.split(TYPE_SEPARATOR)[0].hashCode() : 0;
        int pathHash = this.type != null && this.type.contains(TYPE_SEPARATOR) ? this.type.split(TYPE_SEPARATOR)[1].hashCode() : 0;
        int colorHash = this.color != null ? this.color.hashCode() : 0;
        int variantHash = this.variant != null ? this.variant.hashCode() : 0;
        int result = 17;
        result = 31 * result + namespaceHash;
        result = 31 * result + pathHash;
        result = 31 * result + colorHash;
        result = 31 * result + variantHash;
        result = 31 * result + (this.isFoil ? 1 : 0);
        result ^= result >>> 16;
        return (result & Integer.MAX_VALUE) % 0x1000000;
    }

    public MobCaptureData withColor(MobColor color) {
        return new MobCaptureData(this.name, this.type, this.entityType, this.data, color, this.variant, this.rarity, this.isFoil);
    }

    public MobCaptureData withVariant(String variant) {
        return new MobCaptureData(this.name, this.type, this.entityType, this.data, this.color, variant, this.rarity, this.isFoil);
    }

    public MobCaptureData withRarity(class_1814 rarity) {
        return new MobCaptureData(this.name, this.type, this.entityType, this.data, this.color, this.variant, rarity, this.isFoil);
    }

    public MobCaptureData withFoil(boolean isFoil) {
        return new MobCaptureData(this.name, this.type, this.entityType, this.data, this.color, this.variant, this.rarity, isFoil);
    }

    public MobCaptureData withData(class_2487 data) {
        return new MobCaptureData(this.name, this.type, this.entityType, data, this.color, this.variant, this.rarity, this.isFoil);
    }

    public boolean isEmpty() {
        return this.equals(EMPTY);
    }

    public boolean hasColor() {
        return this.color != null && this.color != MobColor.NONE;
    }

    public boolean hasData() {
        return this.data != null && !this.data.method_33133();
    }

    public boolean hasVariant() {
        return this.variant != null && !this.variant.isEmpty();
    }

    public boolean hasRarity() {
        return this.rarity != null;
    }

    @Override
    public String toString() {
        return "MobCaptureData{, name='" + this.name + ", entityType=" + String.valueOf(this.entityType) + ", color=" + String.valueOf((Object)this.color) + ", variant=" + this.variant + ", rarity=" + String.valueOf(this.rarity) + ", isFoil=" + this.isFoil + ", data=" + String.valueOf(this.data) + "}";
    }
}

