/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.client.event;

import de.markusbordihn.easymobfarm.client.model.ModelManagerInterface;
import de.markusbordihn.easymobfarm.client.model.UnbakedMobCaptureCardModel;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModelEventHandler {
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private static BakedModel mobCaptureCardItemBakedModel;

    private ModelEventHandler() {
    }

    @SubscribeEvent
    public static void onModelRegistry(ModelEvent.RegisterAdditional event) {
        log.info("Registering card models ...");
        Set.of(new ModelResourceLocation(UnbakedMobCaptureCardModel.MODEL, "standalone"), ModelManagerInterface.DEFAULT_MODEL, ModelManagerInterface.DEFAULT_UNCOMMON_MODEL, ModelManagerInterface.DEFAULT_RARE_MODEL, ModelManagerInterface.DEFAULT_EPIC_MODEL, ModelManagerInterface.DEFAULT_FISH_MODEL).forEach(resourceLocation -> {
            log.info("Registering default model {} ...", resourceLocation);
            event.register(resourceLocation);
        });
        ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
        for (ResourceLocation location : resourceManager.listResources("models/item/easy_mob_farm/mob_capture_card", resourceLocation -> resourceLocation.getPath().endsWith(".json")).keySet()) {
            ModelResourceLocation modelResourceLocation = ModelManagerInterface.getModelResourceLocation(location);
            log.info("Automatically registering model {} as {} ...", (Object)location, (Object)modelResourceLocation);
            event.register(modelResourceLocation);
        }
    }

    @SubscribeEvent
    public static void onModelBake(ModelEvent.BakingCompleted event) {
        ModelResourceLocation mobCaptureCardModelResourceLocation = new ModelResourceLocation(ResourceLocation.fromNamespaceAndPath((String)"easy_mob_farm", (String)"mob_capture_card"), "inventory");
        UnbakedMobCaptureCardModel unbakedModel = new UnbakedMobCaptureCardModel(event.getModelBakery().getModel(UnbakedMobCaptureCardModel.MODEL));
        log.info("Baking unbaked model for {} with {} ...", (Object)mobCaptureCardModelResourceLocation, (Object)unbakedModel);
        ModelBakery.ModelBakerImpl baker = new ModelBakery.ModelBakerImpl(event.getModelBakery(), (modelLocation, material) -> material.sprite(), mobCaptureCardModelResourceLocation);
        if (unbakedModel instanceof UnbakedMobCaptureCardModel) {
            UnbakedMobCaptureCardModel unbakedMobCaptureCardModel = unbakedModel;
            BakedModel bakedModel = unbakedMobCaptureCardModel.bake((ModelBaker)baker, Material::sprite, (ModelState)BlockModelRotation.X0_Y0);
            event.getModelBakery().getBakedTopLevelModels().put(mobCaptureCardModelResourceLocation, bakedModel);
        } else {
            log.error("Unable to bake unbaked model for Mob Capture Card.");
        }
    }
}

