/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.experience;

import de.markusbordihn.easymobfarm.experience.ExperienceManagerInterface;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExperienceManager {
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private static final String LOG_PREFIX = "[Experience Manager]";
    private static ExperienceManagerInterface experienceManagerInterface;

    private ExperienceManager() {
    }

    public static void registerExperienceManager(ExperienceManagerInterface experienceManagerInterface) {
        log.info("{} Experience Manager {}", (Object)"Register Easy Mob Farm", (Object)experienceManagerInterface.getClass().getSimpleName());
        ExperienceManager.experienceManagerInterface = experienceManagerInterface;
    }

    public static ExperienceManagerInterface getExperienceManager() {
        return experienceManagerInterface;
    }

    public static int getExperienceReward(ServerLevel serverLevel, LivingEntity livingEntity) {
        if (experienceManagerInterface != null) {
            return experienceManagerInterface.getExperienceReward(serverLevel, livingEntity);
        }
        return 0;
    }

    public static int getExperienceReward(LivingEntity livingEntity) {
        try {
            return experienceManagerInterface.getExperienceReward(livingEntity);
        }
        catch (Exception e) {
            log.error("{} Failed to get experience reward for {}", (Object)LOG_PREFIX, (Object)livingEntity.getClass().getSimpleName(), (Object)e);
            return 0;
        }
    }

    public static boolean shouldDropExperience(LivingEntity livingEntity) {
        if (experienceManagerInterface != null) {
            return experienceManagerInterface.shouldDropExperience(livingEntity);
        }
        return false;
    }
}

