/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.item.mobcapturecard;

import de.markusbordihn.easymobfarm.capture.MobCaptureManager;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureData;
import de.markusbordihn.easymobfarm.network.components.TextComponent;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class MobCaptureCardItem
extends Item {
    public static final String ID = "mob_capture_card";
    public static final ResourceLocation RESOURCE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"easy_mob_farm", (String)"mob_capture_card");
    public static final String TOOLTIP_PREFIX = "tooltip.easy_mob_farm.mob_capture_card.";

    public MobCaptureCardItem() {
        this(new Item.Properties());
    }

    public MobCaptureCardItem(Item.Properties properties) {
        super(properties.fireResistant());
    }

    public static MobCaptureCardItem getMobCaptureCardItem() {
        Object object = BuiltInRegistries.ITEM.get(RESOURCE_LOCATION);
        if (object instanceof MobCaptureCardItem) {
            MobCaptureCardItem mobCaptureCardItem = (MobCaptureCardItem)((Object)object);
            return mobCaptureCardItem;
        }
        return null;
    }

    private static String getVariantName(String variant) {
        if (variant == null || variant.isEmpty()) {
            return "";
        }
        return Arrays.stream(variant.split("_")).map(word -> word.substring(0, 1).toUpperCase(Locale.ROOT) + word.substring(1).toLowerCase(Locale.ROOT)).collect(Collectors.joining(" "));
    }

    private static Component getTranslatedEntityName(MobCaptureData mobCaptureData) {
        if (mobCaptureData == null || mobCaptureData.name() == null) {
            return TextComponent.getText("Unknown");
        }
        return TextComponent.getTranslatedTextRaw(mobCaptureData.name());
    }

    private static void addSpecialMechanicsTooltips(MobCaptureData mobCaptureData, List<Component> tooltip) {
        if (mobCaptureData == null || mobCaptureData.name() == null) {
            return;
        }
        MutableComponent specialMechanicsTooltip = MobCaptureCardItem.tryGetTranslation(TOOLTIP_PREFIX + mobCaptureData.name().replace("entity.", "").replace(":", ".") + ".special_mechanics");
        if (specialMechanicsTooltip != null) {
            tooltip.add((Component)specialMechanicsTooltip.withStyle(ChatFormatting.GRAY));
        }
    }

    private static MutableComponent tryGetTranslation(String translationKey) {
        try {
            MutableComponent translation = TextComponent.getTranslatedTextRaw(translationKey);
            if (translation.getString().equals(translationKey)) {
                return null;
            }
            return translation;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isEnchantable(ItemStack itemStack) {
        return false;
    }

    public boolean canAttackBlock(BlockState blockState, Level level, BlockPos blockPos, Player player) {
        return false;
    }

    public Component getName(ItemStack itemStack) {
        MobCaptureData mobCaptureData = MobCaptureManager.getMobCaptureData(itemStack);
        if (mobCaptureData == null) {
            return super.getName(itemStack);
        }
        Object key = "tooltip.easy_mob_farm.mob_capture_card.card_name";
        Object[] args = new Object[]{MobCaptureCardItem.getTranslatedEntityName(mobCaptureData)};
        if (mobCaptureData.hasVariant() && !mobCaptureData.name().equalsIgnoreCase(mobCaptureData.variant())) {
            if (mobCaptureData.hasColor()) {
                key = (String)key + "_variant_color";
                args = new Object[]{MobCaptureCardItem.getTranslatedEntityName(mobCaptureData), MobCaptureCardItem.getVariantName(mobCaptureData.variant()), mobCaptureData.color().getName()};
            } else {
                key = (String)key + "_variant";
                args = new Object[]{MobCaptureCardItem.getTranslatedEntityName(mobCaptureData), MobCaptureCardItem.getVariantName(mobCaptureData.variant())};
            }
        } else if (mobCaptureData.hasColor()) {
            key = (String)key + "_color";
            args = new Object[]{MobCaptureCardItem.getTranslatedEntityName(mobCaptureData), mobCaptureData.color().getName()};
        }
        return TextComponent.getTranslatedTextRaw((String)key, args).append(" ").append((Component)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_capture_card").withStyle(ChatFormatting.GRAY));
    }

    public boolean isFoil(ItemStack itemStack) {
        MobCaptureData mobCaptureData = MobCaptureManager.getMobCaptureData(itemStack);
        return mobCaptureData != null && mobCaptureData.isFoil();
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag flag) {
        MobCaptureData mobCaptureData = MobCaptureManager.getMobCaptureData(itemStack);
        if (mobCaptureData == null) {
            tooltip.add((Component)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_capture_card.empty"));
            return;
        }
        tooltip.add((Component)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_capture_card.name", MobCaptureCardItem.getTranslatedEntityName(mobCaptureData)));
        if (flag.isAdvanced()) {
            tooltip.add((Component)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_capture_card.description_id", mobCaptureData.name()));
            tooltip.add((Component)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_capture_card.type", mobCaptureData.type()));
        }
        if (mobCaptureData.hasVariant()) {
            tooltip.add((Component)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_capture_card.variant", mobCaptureData.variant()));
        }
        if (mobCaptureData.hasColor()) {
            tooltip.add((Component)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_capture_card.color", mobCaptureData.color().getName()));
        }
        ChatFormatting rarityColor = switch (mobCaptureData.rarity()) {
            case Rarity.UNCOMMON -> ChatFormatting.GREEN;
            case Rarity.RARE -> ChatFormatting.BLUE;
            case Rarity.EPIC -> ChatFormatting.DARK_PURPLE;
            default -> ChatFormatting.GRAY;
        };
        tooltip.add((Component)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_capture_card.rarity", mobCaptureData.rarity().name()).withStyle(rarityColor));
        tooltip.add((Component)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_capture_card.id", String.valueOf(mobCaptureData.getCardId())));
        MobCaptureCardItem.addSpecialMechanicsTooltips(mobCaptureData, tooltip);
    }
}

