/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.loot;

import de.markusbordihn.easymobfarm.compat.CompatConstants;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureData;
import de.markusbordihn.easymobfarm.data.capture.MobVariantData;
import de.markusbordihn.easymobfarm.data.enhancement.FrogCatalystType;
import de.markusbordihn.easymobfarm.experience.ExperienceManager;
import de.markusbordihn.easymobfarm.item.upgrade.EnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.EggCollectorEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.ExperienceEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.FrogCatalystEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.HoneyExtractorEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.HoneyHarvesterFrameEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.LootEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.LuckEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.MilkExtractorEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.PollenTrapEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.SheepEnhancementItem;
import de.markusbordihn.easymobfarm.item.upgrade.enhancement.SwordEnhancementItem;
import de.markusbordihn.easymobfarm.server.player.FakePlayer;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootManager {
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private static final Random random = new Random();
    private static final Map<String, ResourceLocation> FROG_CATALYST_RESOURCES = Map.ofEntries(Map.entry("cold", ResourceLocation.fromNamespaceAndPath((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_COLD)), Map.entry("temperate", ResourceLocation.fromNamespaceAndPath((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_TEMPERATE)), Map.entry("warm", ResourceLocation.fromNamespaceAndPath((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_WARM)), Map.entry("white", ResourceLocation.fromNamespaceAndPath((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_WHITE)), Map.entry("orange", ResourceLocation.fromNamespaceAndPath((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_ORANGE)), Map.entry("magenta", ResourceLocation.fromNamespaceAndPath((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_MAGENTA)), Map.entry("light_blue", ResourceLocation.fromNamespaceAndPath((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_LIGHT_BLUE)), Map.entry("yellow", ResourceLocation.fromNamespaceAndPath((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_YELLOW)), Map.entry("lime", ResourceLocation.fromNamespaceAndPath((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_LIME)), Map.entry("pink", ResourceLocation.fromNamespaceAndPath((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_PINK)), Map.entry("gray", ResourceLocation.fromNamespaceAndPath((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_GRAY)), Map.entry("light_gray", ResourceLocation.fromNamespaceAndPath((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_LIGHT_GRAY)), Map.entry("cyan", ResourceLocation.fromNamespaceAndPath((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_CYAN)), Map.entry("purple", ResourceLocation.fromNamespaceAndPath((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_PURPLE)), Map.entry("blue", ResourceLocation.fromNamespaceAndPath((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_BLUE)), Map.entry("brown", ResourceLocation.fromNamespaceAndPath((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_BROWN)), Map.entry("green", ResourceLocation.fromNamespaceAndPath((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_GREEN)), Map.entry("red", ResourceLocation.fromNamespaceAndPath((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_RED)), Map.entry("black", ResourceLocation.fromNamespaceAndPath((String)"easy_mob_farm", (String)FrogCatalystEnhancementItem.ID_BLACK)));
    private static final EnumMap<FrogCatalystType, ResourceLocation> FROGLIGHT_MAP = new EnumMap(FrogCatalystType.class);
    private static FakePlayer fakePlayer;

    private LootManager() {
    }

    public static NonNullList<ItemStack> getEntityLoot(MobCaptureData mobCaptureData, List<EnhancementItem> enhancements, Level level) {
        EntityType<?> entityType = mobCaptureData.entityType();
        if (entityType == null) {
            log.error("Unable to get entity type from Mob Capture data: {}", (Object)mobCaptureData);
            return NonNullList.create();
        }
        Entity entity = entityType.create(level);
        if (entity == null) {
            log.error("Unable to create entity {}!", entityType);
            return NonNullList.create();
        }
        entity.load(mobCaptureData.data());
        if (entity instanceof Sheep) {
            Sheep sheepEntity = (Sheep)entity;
            sheepEntity.setSheared(false);
            if (mobCaptureData.hasColor()) {
                sheepEntity.setColor(mobCaptureData.color().getDyeColor());
            }
        }
        NonNullList<ItemStack> drops = LootManager.getEntityLoot(entity, enhancements, level);
        entity.discard();
        return drops;
    }

    public static NonNullList<ItemStack> getEntityLoot(Entity entity, List<EnhancementItem> enhancements, Level level) {
        LivingEntity livingEntity;
        NonNullList drops;
        block14: {
            block13: {
                drops = NonNullList.create();
                if (!(entity instanceof LivingEntity)) break block13;
                livingEntity = (LivingEntity)entity;
                if (level instanceof ServerLevel) break block14;
            }
            return drops;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        FakePlayer fakePlayer = LootManager.getFakePlayer(serverLevel, entity.blockPosition());
        LootParams.Builder lootContextBuilder = LootManager.createLootContextBuilder(serverLevel, livingEntity);
        float additionalLuck = 0.0f;
        int additionalRolls = 0;
        for (EnhancementItem enhancement : enhancements) {
            if (enhancement instanceof SwordEnhancementItem) {
                LootManager.setSwordEnhancementParameters(lootContextBuilder, fakePlayer, serverLevel);
                additionalLuck += 0.5f;
            }
            if (enhancement instanceof LootEnhancementItem) {
                ++additionalRolls;
            }
            if (!(enhancement instanceof LuckEnhancementItem)) continue;
            additionalLuck += 1.0f;
        }
        if (additionalLuck > 0.0f) {
            lootContextBuilder.withLuck(additionalLuck);
        }
        ResourceKey<LootTable> lootTableLocation = LootManager.getLootTableLocation(livingEntity, enhancements);
        LootParams lootContext = lootContextBuilder.create(LootContextParamSets.ENTITY);
        if (lootTableLocation != null) {
            LootTable lootTable = serverLevel.getServer().reloadableRegistries().getLootTable(lootTableLocation);
            for (int i = 0; i <= additionalRolls; ++i) {
                lootTable.getRandomItems(lootContext).stream().filter(itemStack -> !itemStack.isEmpty()).forEach(arg_0 -> drops.add(arg_0));
                LootManager.handleSpecialEntityDrops(livingEntity, (NonNullList<ItemStack>)drops);
            }
        }
        if (drops.isEmpty()) {
            ResourceKey<LootTable> customLootTableLocation = LootManager.getCustomLootTableLocation(livingEntity, enhancements);
            LootTable customLootTable = serverLevel.getServer().reloadableRegistries().getLootTable(customLootTableLocation);
            if (customLootTable != LootTable.EMPTY) {
                log.debug("No loot drops for {} trying custom loot table {}!", (Object)livingEntity, customLootTableLocation);
                for (int i = 0; i <= additionalRolls; ++i) {
                    customLootTable.getRandomItems(lootContext).stream().filter(itemStack -> !itemStack.isEmpty()).forEach(arg_0 -> drops.add(arg_0));
                }
            } else {
                log.debug("No loot drops for {} and no custom loot table {}!", (Object)livingEntity, customLootTableLocation);
            }
        }
        LootManager.handlePostEnhancements(enhancements, livingEntity, serverLevel, fakePlayer, (NonNullList<ItemStack>)drops);
        return drops;
    }

    public static NonNullList<ItemStack> getLuckyLoot(MobCaptureData mobCaptureData, BlockPos blockPos, Level Level2) {
        NonNullList drops = NonNullList.create();
        if (!(Level2 instanceof ServerLevel)) {
            return drops;
        }
        ServerLevel serverLevel = (ServerLevel)Level2;
        ResourceKey lootTableLocation = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)(switch (mobCaptureData.rarity()) {
            default -> throw new MatchException(null, null);
            case Rarity.COMMON -> "chests/simple_dungeon";
            case Rarity.UNCOMMON -> "chests/village/village_toolsmith";
            case Rarity.RARE -> "chests/stronghold_library";
            case Rarity.EPIC -> "chests/end_city_treasure";
        })));
        FakePlayer fakePlayer = LootManager.getFakePlayer(serverLevel, blockPos);
        LootTable lootTable = serverLevel.getServer().reloadableRegistries().getLootTable(lootTableLocation);
        LootParams.Builder lootContextBuilder = LootManager.createLootChestContextBuilder(serverLevel, (LivingEntity)fakePlayer);
        lootContextBuilder.withLuck(switch (mobCaptureData.rarity()) {
            default -> throw new MatchException(null, null);
            case Rarity.COMMON -> 0.0f;
            case Rarity.UNCOMMON -> 0.5f;
            case Rarity.RARE -> 1.0f;
            case Rarity.EPIC -> 1.5f;
        });
        LootParams lootContext = lootContextBuilder.create(LootContextParamSets.CHEST);
        lootTable.getRandomItems(lootContext).stream().filter(itemStack -> !itemStack.isEmpty()).forEach(arg_0 -> drops.add(arg_0));
        return drops;
    }

    private static void handleSpecialEntityDrops(LivingEntity livingEntity, NonNullList<ItemStack> drops) {
        if (livingEntity instanceof WitherBoss) {
            if (random.nextInt(2) == 0) {
                drops.add((Object)new ItemStack((ItemLike)Items.NETHER_STAR));
            }
            if (random.nextInt(2) == 0) {
                drops.add((Object)new ItemStack((ItemLike)Items.WITHER_ROSE));
            }
        }
    }

    private static LootParams.Builder createLootContextBuilder(ServerLevel serverLevel, LivingEntity livingEntity) {
        return new LootParams.Builder(serverLevel).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)serverLevel.damageSources().generic()).withParameter(LootContextParams.ORIGIN, (Object)livingEntity.position()).withParameter(LootContextParams.THIS_ENTITY, (Object)livingEntity);
    }

    private static LootParams.Builder createLootChestContextBuilder(ServerLevel serverLevel, LivingEntity livingEntity) {
        return new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)livingEntity.position()).withParameter(LootContextParams.THIS_ENTITY, (Object)livingEntity);
    }

    private static ResourceKey<LootTable> getLootTableLocation(LivingEntity livingEntity, List<EnhancementItem> enhancements) {
        ResourceKey lootTableLocation = livingEntity.getType().getDefaultLootTable();
        for (EnhancementItem enhancement : enhancements) {
            if (!(enhancement instanceof SheepEnhancementItem) || !(livingEntity instanceof Sheep)) continue;
            Sheep sheep = (Sheep)livingEntity;
            DyeColor color = sheep.getColor();
            lootTableLocation = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)("entities/sheep/" + color.getName())));
        }
        return lootTableLocation;
    }

    private static ResourceKey<LootTable> getCustomLootTableLocation(LivingEntity livingEntity, List<EnhancementItem> enhancements) {
        ResourceLocation entityTypeResourceLocation = BuiltInRegistries.ENTITY_TYPE.getKey((Object)livingEntity.getType());
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"easy_mob_farm", (String)("entities/" + entityTypeResourceLocation.getNamespace() + "/" + entityTypeResourceLocation.getPath())));
    }

    private static void setSwordEnhancementParameters(LootParams.Builder lootParamsBuilder, FakePlayer fakePlayer, ServerLevel serverLevel) {
        lootParamsBuilder.withParameter(LootContextParams.DAMAGE_SOURCE, (Object)serverLevel.damageSources().playerAttack((Player)fakePlayer)).withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)fakePlayer).withParameter(LootContextParams.ATTACKING_ENTITY, (Object)fakePlayer).withParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)fakePlayer);
    }

    private static void handlePostEnhancements(List<EnhancementItem> enhancements, LivingEntity livingEntity, ServerLevel serverLevel, FakePlayer fakePlayer, NonNullList<ItemStack> drops) {
        for (EnhancementItem enhancement : enhancements) {
            ResourceLocation frogCatalystResourceLocation;
            ExperienceEnhancementItem experienceEnhancementItem;
            if (enhancement instanceof ExperienceEnhancementItem && random.nextInt((experienceEnhancementItem = (ExperienceEnhancementItem)enhancement).experienceDropChance()) == 0 && ExperienceManager.shouldDropExperience(livingEntity)) {
                int experience = ExperienceManager.getExperienceReward(serverLevel, livingEntity);
                if (experience >= experienceEnhancementItem.minExperienceForDrop()) {
                    drops.add((Object)new ItemStack((ItemLike)Items.EXPERIENCE_BOTTLE));
                } else {
                    log.debug("Experience drop of {} is below minimum threshold of {} for {}", (Object)experience, (Object)experienceEnhancementItem.minExperienceForDrop(), (Object)livingEntity);
                }
            }
            if (livingEntity instanceof Bee) {
                if (enhancement instanceof HoneyHarvesterFrameEnhancementItem && random.nextInt(4) == 0) {
                    drops.add((Object)new ItemStack((ItemLike)Items.HONEYCOMB));
                    continue;
                }
                if (enhancement instanceof HoneyExtractorEnhancementItem && random.nextInt(10) == 0) {
                    drops.add((Object)new ItemStack((ItemLike)Items.HONEY_BOTTLE));
                    continue;
                }
                if (!(enhancement instanceof PollenTrapEnhancementItem) || random.nextInt(5) != 0) continue;
                if (random.nextFloat() < 0.3f) {
                    drops.add((Object)LootManager.getRandomFlower());
                    continue;
                }
                drops.add((Object)LootManager.getRandomDye());
                continue;
            }
            if (livingEntity instanceof Cow) {
                if (!(enhancement instanceof MilkExtractorEnhancementItem) || random.nextInt(2) != 0) continue;
                Item milkBottle = CompatConstants.MOD_FARMERS_DELIGHT_LOADED ? (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"milk_bottle")) : (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"easy_mob_farm", (String)"milk_bottle"));
                drops.add((Object)new ItemStack((ItemLike)milkBottle));
                continue;
            }
            if (livingEntity instanceof Chicken) {
                if (!(enhancement instanceof EggCollectorEnhancementItem) || random.nextInt(2) != 0) continue;
                drops.add((Object)new ItemStack((ItemLike)Items.EGG));
                continue;
            }
            if (livingEntity instanceof Frog) {
                if (random.nextInt(40) != 0) continue;
                String frogVariant = MobVariantData.getVariant(livingEntity);
                ResourceLocation frogCatalystResourceLocation2 = FROG_CATALYST_RESOURCES.get(frogVariant);
                if (frogCatalystResourceLocation2 != null) {
                    Item frogCatalystItem = (Item)BuiltInRegistries.ITEM.get(frogCatalystResourceLocation2);
                    if (frogCatalystItem instanceof FrogCatalystEnhancementItem) {
                        FrogCatalystEnhancementItem frogCatalystEnhancementItem = (FrogCatalystEnhancementItem)frogCatalystItem;
                        drops.add((Object)new ItemStack((ItemLike)frogCatalystEnhancementItem));
                        continue;
                    }
                    log.warn("Frog Catalyst item {} is not an instance of FrogCatalystEnhancementItem!", (Object)frogCatalystItem);
                    continue;
                }
                log.warn("No Frog Catalyst resource found for variant {}!", (Object)frogVariant);
                continue;
            }
            if (!(livingEntity instanceof MagmaCube)) continue;
            if (random.nextInt(8) == 0) {
                drops.add((Object)new ItemStack((ItemLike)Items.MAGMA_CREAM));
            }
            if (!(enhancement instanceof FrogCatalystEnhancementItem)) continue;
            FrogCatalystEnhancementItem frogCatalystEnhancementItem = (FrogCatalystEnhancementItem)enhancement;
            if (random.nextInt(2) != 0) continue;
            FrogCatalystType frogCatalystType = frogCatalystEnhancementItem.getFrogCatalystType();
            switch (frogCatalystType) {
                case COLD: {
                    drops.add((Object)new ItemStack((ItemLike)Items.VERDANT_FROGLIGHT));
                    break;
                }
                case TEMPERATE: {
                    drops.add((Object)new ItemStack((ItemLike)Items.OCHRE_FROGLIGHT));
                    break;
                }
                case WARM: {
                    drops.add((Object)new ItemStack((ItemLike)Items.PEARLESCENT_FROGLIGHT));
                    break;
                }
                default: {
                    if (CompatConstants.MOD_SWAMPIER_SWAMPS_LOADED) break;
                    log.error("Unknown Frog Catalyst type {}", (Object)frogCatalystType);
                }
            }
            if (!CompatConstants.MOD_SWAMPIER_SWAMPS_LOADED || (frogCatalystResourceLocation = FROGLIGHT_MAP.get((Object)frogCatalystType)) == null) continue;
            Item frogCatalystItem = (Item)BuiltInRegistries.ITEM.get(frogCatalystResourceLocation);
            if (frogCatalystItem != Items.AIR) {
                drops.add((Object)new ItemStack((ItemLike)frogCatalystItem));
                continue;
            }
            log.warn("Swampier Swamps: Frog Catalyst item {} is not available!", (Object)frogCatalystType);
        }
    }

    private static FakePlayer getFakePlayer(ServerLevel level, BlockPos blockPos) {
        if (FakePlayer.isInvalidFakePlayer(fakePlayer)) {
            fakePlayer = new FakePlayer(level, blockPos);
            return fakePlayer;
        }
        return fakePlayer.updatePosition(level, blockPos);
    }

    private static ItemStack getRandomFlower() {
        List<Item> flowers = List.of(Items.DANDELION, Items.POPPY, Items.BLUE_ORCHID, Items.ALLIUM, Items.AZURE_BLUET, Items.RED_TULIP, Items.ORANGE_TULIP, Items.WHITE_TULIP, Items.PINK_TULIP, Items.OXEYE_DAISY, Items.CORNFLOWER, Items.LILY_OF_THE_VALLEY);
        return new ItemStack((ItemLike)flowers.get(new Random().nextInt(flowers.size())));
    }

    private static ItemStack getRandomDye() {
        List<Item> dyes = List.of(Items.YELLOW_DYE, Items.RED_DYE, Items.BLUE_DYE, Items.ORANGE_DYE, Items.PINK_DYE, Items.WHITE_DYE, Items.BLACK_DYE);
        return new ItemStack((ItemLike)dyes.get(new Random().nextInt(dyes.size())));
    }

    static {
        if (CompatConstants.MOD_SWAMPIER_SWAMPS_LOADED) {
            FROGLIGHT_MAP.put(FrogCatalystType.WHITE, ResourceLocation.fromNamespaceAndPath((String)"swampier_swamps", (String)"white_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.ORANGE, ResourceLocation.fromNamespaceAndPath((String)"swampier_swamps", (String)"orange_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.MAGENTA, ResourceLocation.fromNamespaceAndPath((String)"swampier_swamps", (String)"magenta_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.LIGHT_BLUE, ResourceLocation.fromNamespaceAndPath((String)"swampier_swamps", (String)"light_blue_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.YELLOW, ResourceLocation.fromNamespaceAndPath((String)"swampier_swamps", (String)"yellow_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.LIME, ResourceLocation.fromNamespaceAndPath((String)"swampier_swamps", (String)"lime_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.PINK, ResourceLocation.fromNamespaceAndPath((String)"swampier_swamps", (String)"pink_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.GRAY, ResourceLocation.fromNamespaceAndPath((String)"swampier_swamps", (String)"gray_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.LIGHT_GRAY, ResourceLocation.fromNamespaceAndPath((String)"swampier_swamps", (String)"light_gray_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.CYAN, ResourceLocation.fromNamespaceAndPath((String)"swampier_swamps", (String)"cyan_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.PURPLE, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"pearlescent_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.BLUE, ResourceLocation.fromNamespaceAndPath((String)"swampier_swamps", (String)"blue_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.BROWN, ResourceLocation.fromNamespaceAndPath((String)"swampier_swamps", (String)"brown_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.GREEN, ResourceLocation.fromNamespaceAndPath((String)"swampier_swamps", (String)"green_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.RED, ResourceLocation.fromNamespaceAndPath((String)"swampier_swamps", (String)"red_froglight"));
            FROGLIGHT_MAP.put(FrogCatalystType.BLACK, ResourceLocation.fromNamespaceAndPath((String)"swampier_swamps", (String)"black_froglight"));
        }
    }
}

