/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.client.event;

import de.markusbordihn.easymobfarm.client.model.ModelManagerInterface;
import de.markusbordihn.easymobfarm.client.model.UnbakedMobCaptureCardModel;
import java.util.Set;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModelEventHandler {
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");

    private ModelEventHandler() {
    }

    public static void registerModelEventHandler() {
        ModelLoadingPlugin.register(pluginContext -> {
            log.info("Registering card models ...");
            Set.of(ModelManagerInterface.DEFAULT_MODEL, ModelManagerInterface.DEFAULT_UNCOMMON_MODEL, ModelManagerInterface.DEFAULT_RARE_MODEL, ModelManagerInterface.DEFAULT_EPIC_MODEL, ModelManagerInterface.DEFAULT_FISH_MODEL).forEach(modelResourceLocation -> {
                log.info("Registering default model {} ...", (Object)modelResourceLocation.comp_2875());
                pluginContext.addModels(new class_2960[]{modelResourceLocation.comp_2875()});
            });
            class_3300 resourceManager = class_310.method_1551().method_1478();
            for (class_2960 location : resourceManager.method_14488("models/item/easy_mob_farm/mob_capture_card", resourceLocation -> resourceLocation.method_12832().endsWith(".json")).keySet()) {
                class_1091 modelResourceLocation2 = ModelManagerInterface.getModelResourceLocation(location);
                log.info("Automatically registering model {} as {} ...", (Object)location, (Object)modelResourceLocation2);
                pluginContext.addModels(new class_2960[]{modelResourceLocation2.comp_2875()});
            }
            pluginContext.modifyModelOnLoad().register((originalModel, onLoadContext) -> {
                class_1091 modelResourceLocation = onLoadContext.topLevelId();
                if (modelResourceLocation == null) {
                    return originalModel;
                }
                class_2960 resourceLocation = modelResourceLocation.comp_2875();
                if (resourceLocation.method_12836().equals("easy_mob_farm") && resourceLocation.method_12832().equals("mob_capture_card")) {
                    log.info("Adjusting baked model for {} ...", (Object)modelResourceLocation);
                    class_1100 unbakedModel = onLoadContext.getOrLoadModel(UnbakedMobCaptureCardModel.MODEL);
                    if (unbakedModel == null) {
                        log.error("Unable to load unbaked model for resource location {} from {}", (Object)modelResourceLocation, (Object)UnbakedMobCaptureCardModel.MODEL);
                        return originalModel;
                    }
                    log.info("Baking unbaked model for {} ...", (Object)modelResourceLocation);
                    return new UnbakedMobCaptureCardModel(unbakedModel);
                }
                return originalModel;
            });
        });
    }
}

