/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.capture;

import de.markusbordihn.easymobfarm.data.capture.MobCaptureData;
import de.markusbordihn.easymobfarm.data.capture.MobEntityData;
import de.markusbordihn.easymobfarm.data.capture.MobVariantData;
import de.markusbordihn.easymobfarm.item.mobcapturecard.MobCaptureCardItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MobCaptureManager {
    public static final String MOB_CAPTURE_DATA_TAG = "MobCaptureData";
    public static final String COLOR_TAG = "Color";
    public static final String VARIANT_TAG = "variant";
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private static final String LOG_PREFIX = "[MobCaptureManager]";

    private MobCaptureManager() {
    }

    public static ItemStack getMobCaptureCardItem(EntityType<?> entityType, Level level) {
        if (entityType == null || level == null) {
            return null;
        }
        Entity entity = entityType.m_20615_(level);
        if (entity == null) {
            log.error("{} Unable to create entity {}!", (Object)LOG_PREFIX, entityType);
            return null;
        }
        if (!(entity instanceof LivingEntity)) {
            log.error("{} Entity {} is not a living entity!", (Object)LOG_PREFIX, entityType);
            entity.m_146870_();
            return null;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        ItemStack itemStack = MobCaptureManager.getMobCaptureCardItem(livingEntity);
        log.debug("{} Captured mob {} with data:{}.", (Object)LOG_PREFIX, entityType, (Object)itemStack);
        entity.m_146870_();
        return itemStack;
    }

    public static ItemStack getMobCaptureCardItem(LivingEntity livingEntity) {
        if (livingEntity == null || livingEntity instanceof Player || livingEntity.m_9236_().f_46443_) {
            return null;
        }
        MobCaptureCardItem mobCaptureCardItem = MobCaptureCardItem.getMobCaptureCardItem();
        if (mobCaptureCardItem == null) {
            log.error("{} Unable to find mob capture card item!", (Object)LOG_PREFIX);
            return null;
        }
        MobCaptureData mobCaptureData = new MobCaptureData(livingEntity);
        if (mobCaptureData.entityType() == null || mobCaptureData.data() == null) {
            log.debug("{} Unable to get mob capture data from living entity {}.", (Object)LOG_PREFIX, (Object)livingEntity);
            return null;
        }
        mobCaptureData = mobCaptureData.withData(MobEntityData.removeSafeToRemoveMobCaptureCardTags(mobCaptureData.data()));
        ItemStack itemStack = new ItemStack((ItemLike)mobCaptureCardItem);
        MobCaptureManager.writeMobCaptureData(itemStack, mobCaptureData);
        log.debug("{} Captured mob {} with data:{}", (Object)LOG_PREFIX, mobCaptureData.entityType(), (Object)mobCaptureData.data());
        return itemStack;
    }

    public static boolean releaseMob(MobCaptureData mobCaptureData, BlockPos blockPos, ServerLevel serverLevel) {
        BlockPos safeSpawnBlockPos;
        if (mobCaptureData == null || mobCaptureData.entityType() == null) {
            return false;
        }
        EntityType<?> entityType = mobCaptureData.entityType();
        if (entityType == null) {
            return false;
        }
        Entity entity = entityType.m_20615_((Level)serverLevel);
        if (entity == null) {
            log.error("{} Unable to create entity {}!", (Object)LOG_PREFIX, entityType);
            return false;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.m_7378_(mobCaptureData.data());
        }
        if ((safeSpawnBlockPos = MobCaptureManager.getSafeSpawnPos((Level)serverLevel, blockPos)) == null) {
            log.warn("{} Unable to release mob {} with data:{} at block position {}.", (Object)LOG_PREFIX, entityType, (Object)mobCaptureData.data(), (Object)blockPos);
            return false;
        }
        entity.m_7678_((double)safeSpawnBlockPos.m_123341_() + 0.5, (double)safeSpawnBlockPos.m_123342_() + 1.0, (double)safeSpawnBlockPos.m_123343_() + 0.5, 0.0f, 0.0f);
        serverLevel.m_7967_(entity);
        log.debug("{} Released mob {} with data:{} at block position {}.", (Object)LOG_PREFIX, entityType, (Object)mobCaptureData.data(), (Object)safeSpawnBlockPos);
        return true;
    }

    public static ItemStack createMobCaptureCard(ItemLike itemLike, MobCaptureData mobCaptureData) {
        if (itemLike == null) {
            return null;
        }
        ItemStack itemStack = new ItemStack(itemLike);
        MobCaptureManager.writeMobCaptureData(itemStack, mobCaptureData);
        return itemStack;
    }

    public static ItemStack createMobCaptureCard(ItemLike itemLike, EntityType<?> entityType) {
        if (itemLike == null || entityType == null) {
            return null;
        }
        return MobCaptureManager.createMobCaptureCard(itemLike, new MobCaptureData(entityType).withFoil(false));
    }

    public static ItemStack createMobCaptureCard(ItemLike itemLike, EntityType<?> entityType, String variant, DyeColor dyeColor) {
        if (itemLike == null || entityType == null) {
            return null;
        }
        MobCaptureData mobCaptureData = new MobCaptureData(entityType).withFoil(false);
        CompoundTag compoundTag = new CompoundTag();
        if (variant != null) {
            mobCaptureData = mobCaptureData.withVariant(variant);
            if (entityType == EntityType.f_20553_) {
                compoundTag.m_128359_(VARIANT_TAG, variant);
            } else if (entityType == EntityType.f_217012_) {
                compoundTag.m_128359_(VARIANT_TAG, BuiltInRegistries.f_256770_.m_7981_((Object)MobVariantData.getFrogVariant(variant)).toString());
            }
        }
        if (dyeColor != null) {
            mobCaptureData = mobCaptureData.withColor(dyeColor);
            compoundTag.m_128405_(COLOR_TAG, dyeColor.m_41060_());
        }
        return MobCaptureManager.createMobCaptureCard(itemLike, mobCaptureData.withData(compoundTag));
    }

    public static void writeMobCaptureData(ItemStack itemStack, MobCaptureData mobCaptureData) {
        if (itemStack == null || itemStack.m_41619_() || mobCaptureData == null) {
            return;
        }
        CompoundTag compoundTag = itemStack.m_41784_();
        compoundTag.m_128365_(MOB_CAPTURE_DATA_TAG, (Tag)mobCaptureData.createTag());
        itemStack.m_41751_(compoundTag);
    }

    public static boolean hasMobCaptureData(ItemStack itemStack) {
        return itemStack != null && !itemStack.m_41619_() && itemStack.m_41782_() && itemStack.m_41783_().m_128441_(MOB_CAPTURE_DATA_TAG);
    }

    public static MobCaptureData getMobCaptureData(ItemStack itemStack) {
        if (itemStack == null || itemStack.m_41619_()) {
            return null;
        }
        CompoundTag tag = itemStack.m_41783_();
        if (tag != null && tag.m_128441_(MOB_CAPTURE_DATA_TAG)) {
            return new MobCaptureData(tag.m_128469_(MOB_CAPTURE_DATA_TAG));
        }
        return new MobCaptureData(itemStack, tag);
    }

    public static boolean isSafeSpawnPos(Level level, BlockPos blockPos) {
        BlockState surfaceState = level.m_8055_(blockPos.m_7495_());
        BlockState groundState = level.m_8055_(blockPos.m_6625_(2));
        VoxelShape surfaceShape = surfaceState.m_60812_((BlockGetter)level, blockPos.m_7495_());
        VoxelShape groundShape = groundState.m_60812_((BlockGetter)level, blockPos.m_6625_(2));
        double surfaceHeight = surfaceShape.m_83281_() ? 0.0 : surfaceShape.m_83215_().f_82292_;
        double groundHeight = groundShape.m_83281_() ? 0.0 : groundShape.m_83215_().f_82292_;
        return (!surfaceState.m_60795_() || !(surfaceHeight < 0.05)) && !groundState.m_60795_() && groundHeight >= 0.5;
    }

    public static BlockPos getSafeSpawnPos(Level level, BlockPos blockPos) {
        if (MobCaptureManager.isSafeSpawnPos(level, blockPos)) {
            return blockPos;
        }
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                BlockPos nearbyPos;
                if (dx == 0 && dz == 0 || !MobCaptureManager.isSafeSpawnPos(level, nearbyPos = blockPos.m_7918_(dx, 0, dz))) continue;
                return nearbyPos;
            }
        }
        return null;
    }
}

