/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.client.screen;

import de.markusbordihn.easymobfarm.block.entity.MobFarmBlockEntity;
import de.markusbordihn.easymobfarm.client.renderer.manager.EntityScalingManager;
import de.markusbordihn.easymobfarm.client.renderer.manager.RendererManager;
import de.markusbordihn.easymobfarm.client.screen.ContainerScreen;
import de.markusbordihn.easymobfarm.client.screen.ScreenHelper;
import de.markusbordihn.easymobfarm.client.screen.components.Graphics;
import de.markusbordihn.easymobfarm.config.MobFarmBonusConfig;
import de.markusbordihn.easymobfarm.config.MobFarmConfig;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureCardDefinition;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureCardDefinitionManager;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmType;
import de.markusbordihn.easymobfarm.menu.MobFarmMenu;
import de.markusbordihn.easymobfarm.menu.MobFarmSlot;
import de.markusbordihn.easymobfarm.menu.slots.OutputSlot;
import de.markusbordihn.easymobfarm.network.components.TextComponent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class MobFarmScreen<T extends MobFarmMenu>
extends ContainerScreen<T> {
    private static final ResourceLocation TEXTURE_UI = new ResourceLocation("easy_mob_farm", "textures/gui/mob_farm.png");
    private static final ResourceLocation TEXTURE_UI_IDLE = new ResourceLocation("easy_mob_farm", "textures/gui/mob_farm_idle.png");
    private static final ResourceLocation TEXTURE_ELEMENTS = new ResourceLocation("easy_mob_farm", "textures/gui/mob_farm_elements.png");
    protected float xMouse;
    protected float yMouse;
    protected Entity entity;
    protected int entityExperience;

    public MobFarmScreen(T menu, Inventory inventory, Component component) {
        super(menu, inventory, component);
    }

    public static MutableComponent getLocalizedRemainingTimeComponent(int totalTicks, int currentProgress, int speed, int bonus) {
        float ticksPerSecond;
        int remainingTicks = Math.max(0, totalTicks - currentProgress);
        float secondsRemaining = (float)remainingTicks / (ticksPerSecond = Math.max(1.0f, (float)(speed + bonus)));
        int totalSeconds = Math.round(secondsRemaining);
        if (totalSeconds < 60) {
            return TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.next_drop.seconds", totalSeconds);
        }
        int minutes = totalSeconds / 60;
        int seconds = totalSeconds % 60;
        return TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.next_drop.full", new Object[]{minutes, seconds});
    }

    @Override
    protected void renderDefaultScreenBg(GuiGraphics guiGraphics, int leftPos, int topPos) {
        Graphics.blit(guiGraphics, this.menu.getMobFarmStatus() == 0 ? TEXTURE_UI_IDLE : TEXTURE_UI, leftPos, topPos, 0, 0, 256, 243);
    }

    public void m_88315_(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        this.xMouse = x;
        this.yMouse = y;
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, x, y, partialTicks);
        this.renderLockedSlot(guiGraphics, x, y);
        this.renderEntityType(guiGraphics, x, y);
        this.renderMobFarmProgress(guiGraphics, x, y);
        this.m_280072_(guiGraphics, x, y);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int x, int y) {
    }

    private void renderMobFarmProgress(GuiGraphics guiGraphics, int x, int y) {
        int mobFarmProgress = ((MobFarmMenu)this.m_6262_()).getMobFarmProgress();
        int currentWidth = mobFarmProgress * 32 / MobFarmConfig.farmProgressingTime;
        Graphics.blit(guiGraphics, TEXTURE_ELEMENTS, this.f_97735_ + 113, this.f_97736_ + 78, 0, 36, currentWidth, 16);
    }

    private void renderEntityType(GuiGraphics guiGraphics, int x, int y) {
        BlockPos blockPos = ((MobFarmMenu)this.m_6262_()).getMobFarmBlockPos();
        if (blockPos == null || blockPos.equals((Object)BlockPos.f_121853_)) {
            return;
        }
        int mobFarmStatus = ((MobFarmMenu)this.m_6262_()).getMobFarmStatus();
        if (mobFarmStatus == 0) {
            return;
        }
        this.entity = RendererManager.getEntity(blockPos);
        if (this.entity != null) {
            ScreenHelper.renderEntity(this.f_97735_ + 72, this.f_97736_ + 80, (float)(this.f_97735_ + 70) - this.xMouse, (float)(this.f_97736_ + 40) - this.yMouse, EntityScalingManager.getUIScale(this.entity), this.entity);
        } else if (this.entityExperience > 0) {
            this.entityExperience = 0;
        }
    }

    private void renderLockedSlot(GuiGraphics guiGraphics, int x, int y) {
        for (Slot slot : this.menu.f_38839_) {
            OutputSlot outputSlot;
            if (!(slot instanceof OutputSlot) || (outputSlot = (OutputSlot)slot).m_6659_()) continue;
            Graphics.blit(guiGraphics, TEXTURE_ELEMENTS, this.f_97735_ + slot.f_40220_ - 1, this.f_97736_ + slot.f_40221_ - 1, 0, 18, 18, 18);
        }
    }

    public void m_280072_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280072_(guiGraphics, mouseX, mouseY);
        MobFarmType mobFarmType = ((MobFarmMenu)this.m_6262_()).getMobFarmType();
        boolean isAdvanced = Minecraft.m_91087_().f_91066_.f_92125_;
        for (Slot slot : this.menu.f_38839_) {
            MobFarmSlot mobFarmSlot;
            if (!(slot instanceof MobFarmSlot) || (mobFarmSlot = (MobFarmSlot)slot).getTooltip() == null || !this.m_6774_(slot.f_40220_, slot.f_40221_, 16, 16, mouseX, mouseY) || slot.m_6657_()) continue;
            this.renderSlotTooltip(guiGraphics, mobFarmSlot, mouseX, mouseY);
        }
        if (this.m_6774_(24, 17, 10, 13, mouseX, mouseY)) {
            ArrayList<MutableComponent> infoText = new ArrayList<MutableComponent>(List.of());
            if (mobFarmType != null) {
                MutableComponent mutableComponent = TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm." + mobFarmType.getId(), String.valueOf(((MobFarmMenu)this.m_6262_()).getMobFarmTierLevel()));
                infoText.add(mutableComponent.m_130940_(switch (((MobFarmMenu)this.m_6262_()).getMobFarmTierLevel()) {
                    case 1 -> ChatFormatting.GREEN;
                    case 2 -> ChatFormatting.YELLOW;
                    case 3 -> ChatFormatting.RED;
                    default -> ChatFormatting.WHITE;
                }));
            }
            infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.tier", new Object[]{((MobFarmMenu)this.m_6262_()).getMobFarmTierLevel()}));
            infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.status", (Component)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.status_" + ((MobFarmMenu)this.m_6262_()).getMobFarmStatus())));
            if (((MobFarmMenu)this.m_6262_()).getMobFarmStatus() == 200) {
                infoText.add(MobFarmScreen.getLocalizedRemainingTimeComponent(MobFarmConfig.farmProgressingTime, ((MobFarmMenu)this.m_6262_()).getMobFarmProgress(), ((MobFarmMenu)this.m_6262_()).getMobFarmProgressionSpeed(), ((MobFarmMenu)this.m_6262_()).getMobFarmProgressionSpeedBonus()));
            }
            if (isAdvanced) {
                infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.progress", new Object[]{((MobFarmMenu)this.m_6262_()).getMobFarmProgress(), MobFarmConfig.farmProgressingTime}));
            }
            infoText.add(TextComponent.getTranslatedText("tier_level_processing_speed", MobFarmBlockEntity.getProcessingSpeed(((MobFarmMenu)this.m_6262_()).getMobFarmTierLevel(), ((MobFarmMenu)this.m_6262_()).getMobFarmProgressionSpeedBonus())));
            if (isAdvanced) {
                infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.progression_speed", new Object[]{((MobFarmMenu)this.m_6262_()).getMobFarmProgressionSpeed(), ((MobFarmMenu)this.m_6262_()).getMobFarmProgressionSpeedBonus()}));
            }
            infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.output_slots", new Object[]{((MobFarmMenu)this.m_6262_()).getMobFarmNumberOfOutputSlots()}));
            if (mobFarmType == MobFarmType.LUCKY_DROP_FARM) {
                infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.lucky_drop_percentage", new Object[]{MobFarmConfig.luckyDropFarmLuckPercentage}));
                if (MobFarmConfig.luckyDropFarmLuckPercentage < 100) {
                    infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.lucky_drop_warn").m_130940_(ChatFormatting.RED));
                }
            }
            if (this.entity != null && ((MobFarmMenu)this.m_6262_()).getMobFarmStatus() != 0) {
                int capturedMobExperience;
                infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.entity_type", new Object[]{this.entity.m_6095_()}));
                MobCaptureCardDefinition mobCaptureCardDefinition = MobCaptureCardDefinitionManager.get(this.entity.m_6095_());
                if (mobCaptureCardDefinition != null && mobCaptureCardDefinition.requiresKilledByPlayer()) {
                    infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.killed_by_player").m_130940_(ChatFormatting.RED));
                }
                if ((capturedMobExperience = ((MobFarmMenu)this.m_6262_()).getCapturedMobExperience()) >= 3) {
                    infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.experience", new Object[]{capturedMobExperience}).m_130940_(ChatFormatting.GREEN));
                } else if (capturedMobExperience > 0) {
                    infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.low_experience", new Object[]{capturedMobExperience}).m_130940_(ChatFormatting.YELLOW));
                } else if (capturedMobExperience == 0) {
                    infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.no_experience").m_130940_(ChatFormatting.RED));
                }
                ItemStack bonusLootDrop = MobFarmBonusConfig.getBonusDropEntry(((MobFarmMenu)this.m_6262_()).getMobFarmType(), ((MobFarmMenu)this.m_6262_()).getMobFarmTierLevel(), this.entity.m_6095_());
                if (!bonusLootDrop.m_41619_()) {
                    infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.bonus_drop", new Object[]{bonusLootDrop.m_41611_()}).m_130940_(ChatFormatting.GREEN));
                } else {
                    infoText.add(TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.no_bonus_drop").m_130940_(ChatFormatting.GRAY));
                }
            }
            guiGraphics.m_280666_(this.f_96547_, infoText, mouseX, mouseY);
        }
    }

    private void renderSlotTooltip(GuiGraphics guiGraphics, MobFarmSlot mobFarmSlot, int mouseX, int mouseY) {
        Component component = mobFarmSlot.getTooltip();
        if (component == null) {
            return;
        }
        List wrappedText = this.f_96547_.m_92923_((FormattedText)component, 150);
        guiGraphics.m_280245_(this.f_96547_, wrappedText, mouseX, mouseY);
    }
}

