/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.client.model;

import de.markusbordihn.easymobfarm.data.capture.MobCaptureCardDefinition;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureCardDefinitionManager;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_1299;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3489;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface ModelManagerInterface {
    public static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    public static final Set<String> KNOWN_MISSING_MODELS = new HashSet<String>();
    public static final String LOG_PREFIX = "[Model Manager]";
    public static final String MODEL_SEARCH_PATH = "/easy_mob_farm/mob_capture_card/";
    public static final class_1091 DEFAULT_MODEL = new class_1091(new class_2960("easy_mob_farm", "mob_capture_card/default"), "inventory");
    public static final class_1091 DEFAULT_UNCOMMON_MODEL = new class_1091(new class_2960("easy_mob_farm", "mob_capture_card/default_uncommon"), "inventory");
    public static final class_1091 DEFAULT_RARE_MODEL = new class_1091(new class_2960("easy_mob_farm", "mob_capture_card/default_rare"), "inventory");
    public static final class_1091 DEFAULT_EPIC_MODEL = new class_1091(new class_2960("easy_mob_farm", "mob_capture_card/default_epic"), "inventory");
    public static final class_1091 DEFAULT_FISH_MODEL = new class_1091(new class_2960("easy_mob_farm", "mob_capture_card/default_fish"), "inventory");

    private static boolean isFish(class_1299<?> entityType) {
        class_2960 entityId = class_1299.method_5890(entityType);
        class_1792 correspondingItem = (class_1792)class_7923.field_41178.method_10223(entityId);
        return correspondingItem != class_1802.field_8162 && correspondingItem.method_40131().method_40220(class_3489.field_15527);
    }

    public static class_1091 getModelResourceLocation(class_2960 resourceLocation) {
        return new class_1091(new class_2960(resourceLocation.method_12836(), resourceLocation.method_12832().replaceFirst("^models/", "").replaceFirst("^item/", "").replaceFirst("\\.json$", "")), "inventory");
    }

    public static boolean isMobCaptureCardModel(class_2960 resourceLocation) {
        return resourceLocation != null && resourceLocation.method_12832().contains(MODEL_SEARCH_PATH);
    }

    default public class_1087 getModel(class_1091 modelResourceLocation) {
        if (modelResourceLocation == null) {
            return null;
        }
        class_1087 bakedModel = class_310.method_1551().method_1554().method_4742(modelResourceLocation);
        if (bakedModel == class_310.method_1551().method_1554().method_4744()) {
            if (KNOWN_MISSING_MODELS.add(modelResourceLocation.toString())) {
                log.error("{} Missing model for '{}'", (Object)LOG_PREFIX, (Object)modelResourceLocation);
            }
            return null;
        }
        return bakedModel != class_310.method_1551().method_1554().method_4744() ? bakedModel : null;
    }

    default public class_1087 getModel(String type, String variant, class_1767 color) {
        class_1087 bakedModel;
        MobCaptureCardDefinition mobCaptureCardDefinition = MobCaptureCardDefinitionManager.get(new class_2960(type));
        if (mobCaptureCardDefinition == null) {
            return null;
        }
        class_1091 modelResourceLocation = null;
        if (variant != null && !variant.isBlank() && color != null) {
            if (mobCaptureCardDefinition.variants().containsKey(variant) && mobCaptureCardDefinition.variants().get(variant).colors().containsKey(color)) {
                modelResourceLocation = ModelManagerInterface.getModelResourceLocation(mobCaptureCardDefinition.variants().get(variant).colors().get(color).model());
            }
        } else if (variant != null && !variant.isBlank()) {
            if (mobCaptureCardDefinition.variants().containsKey(variant)) {
                modelResourceLocation = ModelManagerInterface.getModelResourceLocation(mobCaptureCardDefinition.variants().get(variant).model());
            }
        } else if (color != null) {
            String colorName = color.method_7792().toLowerCase(Locale.ROOT);
            if (mobCaptureCardDefinition.colors().containsKey(colorName)) {
                modelResourceLocation = ModelManagerInterface.getModelResourceLocation(mobCaptureCardDefinition.colors().get(colorName).model());
            }
        }
        class_1091 defaultModelResourceLocation = ModelManagerInterface.getModelResourceLocation(mobCaptureCardDefinition.model());
        if (modelResourceLocation == null) {
            modelResourceLocation = defaultModelResourceLocation;
        }
        if ((bakedModel = this.getModel(modelResourceLocation)) == class_310.method_1551().method_1554().method_4744()) {
            bakedModel = class_310.method_1551().method_1554().method_4742(defaultModelResourceLocation);
        }
        return bakedModel;
    }

    default public class_1087 getModel(String type) {
        return this.getModel(type, null, null);
    }

    default public class_1087 getModel(class_1814 rarity) {
        if (rarity == null) {
            return null;
        }
        class_1091 modelResourceLocation = switch (rarity) {
            default -> throw new IncompatibleClassChangeError();
            case class_1814.field_8906 -> DEFAULT_MODEL;
            case class_1814.field_8907 -> DEFAULT_UNCOMMON_MODEL;
            case class_1814.field_8903 -> DEFAULT_RARE_MODEL;
            case class_1814.field_8904 -> DEFAULT_EPIC_MODEL;
        };
        return this.getModel(modelResourceLocation);
    }

    default public class_1087 getModel(class_1299<?> entityType) {
        if (entityType == null || !ModelManagerInterface.isFish(entityType)) {
            return null;
        }
        return this.getModel(DEFAULT_FISH_MODEL);
    }

    default public class_1087 getDefaultModel() {
        return this.getModel(DEFAULT_MODEL);
    }
}

