/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.item.mobcatcher;

import de.markusbordihn.easymobfarm.block.MobFarmBlock;
import de.markusbordihn.easymobfarm.block.entity.MobFarmBlockEntity;
import de.markusbordihn.easymobfarm.capture.MobCaptureManager;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureData;
import de.markusbordihn.easymobfarm.item.MobFarmItem;
import de.markusbordihn.easymobfarm.network.components.TextComponent;
import java.util.List;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_4048;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MobCatcherItem
extends MobFarmItem {
    public static final String ID = "mob_catcher";
    public static final String MOB_CAPTURE_DATA_TAG = "MobCaptureData";
    public static final String CUSTOM_MODEL_DATA_TAG = "CustomModelData";
    public static final String TOOLTIP_PREFIX = "tooltip.easy_mob_farm.mob_catcher.";
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private static final float REQUIRED_HEALTH_PERCENTAGE_TO_CAPTURE = 0.25f;
    private static final float MAX_ENTITY_HEIGHT_TO_CAPTURE = 2.0f;
    private static final float MAX_ENTITY_WIDTH_TO_CAPTURE = 1.5f;
    private static final int ITEM_DAMAGE_ON_USE = 1;
    private static final Set<String> allowList = Set.of();
    private static final Set<String> denyList = Set.of();

    public MobCatcherItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public boolean hasMobCaptureData(class_1799 itemStack) {
        return itemStack != null && itemStack.method_7985() && itemStack.method_7969() != null && itemStack.method_7969().method_10545(MOB_CAPTURE_DATA_TAG);
    }

    public float getRequiredHealthPercentageToCapture() {
        return 0.25f;
    }

    public float getMaxEntityHeightToCapture() {
        return 2.0f;
    }

    public float getMaxEntityWidthToCapture() {
        return 1.5f;
    }

    public int getItemDamageOnUse() {
        return 1;
    }

    public Set<String> getAllowList() {
        return allowList;
    }

    public Set<String> getDenyList() {
        return denyList;
    }

    public boolean method_7886(class_1799 itemStack) {
        return this.hasMobCaptureData(itemStack);
    }

    public class_1269 method_7884(class_1838 context) {
        MobFarmBlockEntity mobFarmBlockEntity;
        class_2586 class_25862;
        class_1937 level = context.method_8045();
        class_2338 blockPos = context.method_8037();
        class_1799 itemStack = context.method_8041();
        if (!this.hasMobCaptureData(itemStack)) {
            return class_1269.field_5814;
        }
        if (level.method_8320(blockPos).method_26204() instanceof MobFarmBlock && (class_25862 = level.method_8321(blockPos)) instanceof MobFarmBlockEntity && !(mobFarmBlockEntity = (MobFarmBlockEntity)class_25862).hasCapturedMob()) {
            return class_1269.field_5811;
        }
        if (!level.field_9236 && level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            MobCaptureData mobCaptureData = new MobCaptureData(itemStack.method_7969().method_10562(MOB_CAPTURE_DATA_TAG));
            if (MobCaptureManager.releaseMob(mobCaptureData, blockPos, serverLevel)) {
                itemStack.method_7969().method_10551(MOB_CAPTURE_DATA_TAG);
                itemStack.method_7948().method_10569(CUSTOM_MODEL_DATA_TAG, 0);
                return class_1269.field_5812;
            }
        }
        return class_1269.method_29236((boolean)level.field_9236);
    }

    public class_1269 method_7847(class_1799 itemStack, class_1657 player, class_1309 livingEntity, class_1268 hand) {
        float healthPercentage;
        if (livingEntity == null || livingEntity instanceof class_1657 || livingEntity.method_29504()) {
            return class_1269.field_5814;
        }
        if (this.hasMobCaptureData(itemStack)) {
            return class_1269.field_5814;
        }
        if (this.getItemDamageOnUse() > 0) {
            itemStack.method_7956(this.getItemDamageOnUse(), (class_1309)player, playerEntity -> playerEntity.method_20236(hand));
        }
        String entityName = class_7923.field_41177.method_10221((Object)livingEntity.method_5864()).toString();
        if (!this.getAllowList().isEmpty()) {
            if (!this.getAllowList().contains(entityName)) {
                log.debug("Mob {} is not on the allow list for {}.", (Object)entityName, (Object)this);
                player.method_7353((class_2561)TextComponent.getTranslatedText("mob_is_not_on_allow_list", livingEntity.method_5476().getString()), true);
                return class_1269.field_5814;
            }
        } else {
            if (!this.getDenyList().isEmpty() && this.getDenyList().contains(entityName)) {
                log.debug("Mob {} is on the deny list for {}.", (Object)entityName, (Object)this);
                player.method_7353((class_2561)TextComponent.getTranslatedText("mob_is_on_deny_list", livingEntity.method_5476().getString()), true);
                return class_1269.field_5814;
            }
            if (this.getMaxEntityHeightToCapture() > 0.0f || this.getMaxEntityWidthToCapture() > 0.0f) {
                class_4048 dimensions = livingEntity.method_18377(livingEntity.method_18376());
                if (dimensions.field_18068 > this.getMaxEntityHeightToCapture() || dimensions.field_18067 > this.getMaxEntityWidthToCapture()) {
                    log.debug("Mob {} with {}x{} size is too large to be captured by {}.", (Object)entityName, (Object)Float.valueOf(dimensions.field_18067), (Object)Float.valueOf(dimensions.field_18068), (Object)this);
                    player.method_7353((class_2561)TextComponent.getTranslatedText("too_large_to_capture", livingEntity.method_5476().getString()), true);
                    return class_1269.field_5814;
                }
            }
        }
        if (this.getRequiredHealthPercentageToCapture() > 0.0f && (healthPercentage = livingEntity.method_6032() / livingEntity.method_6063()) > this.getRequiredHealthPercentageToCapture()) {
            log.debug("Mob {} with {} health is too strong to be captured by {}.", (Object)entityName, (Object)Float.valueOf(healthPercentage), (Object)this);
            player.method_7353((class_2561)TextComponent.getTranslatedText("too_strong_to_capture", livingEntity.method_5476().getString()), true);
            return class_1269.field_5814;
        }
        class_1937 level = livingEntity.method_37908();
        if (level.field_9236) {
            return class_1269.field_5812;
        }
        MobCaptureData mobCaptureData = new MobCaptureData(livingEntity);
        itemStack.method_7948().method_10566(MOB_CAPTURE_DATA_TAG, (class_2520)mobCaptureData.createTag());
        itemStack.method_7948().method_10569(CUSTOM_MODEL_DATA_TAG, 1);
        player.method_6122(hand, itemStack);
        livingEntity.method_31472();
        player.method_7353((class_2561)TextComponent.getTranslatedText("captured_mob", mobCaptureData.name(), mobCaptureData.type()), true);
        return class_1269.field_21466;
    }

    public void method_7851(class_1799 itemStack, class_1937 level, List<class_2561> tooltip, class_1836 flag) {
        if (this.hasMobCaptureData(itemStack)) {
            MobCaptureData mobCaptureData = MobCaptureManager.getMobCaptureData(itemStack);
            this.addTooltip(tooltip, (class_2561)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_catcher.release_hint", mobCaptureData.name()).method_27692(class_124.field_1079));
            this.addTooltip(tooltip, (class_2561)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_catcher.name", mobCaptureData.name()));
            if (flag.method_8035()) {
                this.addTooltip(tooltip, (class_2561)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_catcher.type", mobCaptureData.type()));
            }
            if (mobCaptureData.variant() != null) {
                this.addTooltip(tooltip, (class_2561)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_catcher.variant", mobCaptureData.variant()));
            }
            if (mobCaptureData.color() != null) {
                this.addTooltip(tooltip, (class_2561)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_catcher.color", mobCaptureData.color().method_7792()));
            }
        } else {
            this.addTooltip(tooltip, (class_2561)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_catcher.capture_hint").method_27692(class_124.field_1077));
            this.addTooltip(tooltip, (class_2561)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_catcher.max_size", this.getMaxEntityWidthToCapture() + "x" + this.getMaxEntityHeightToCapture()));
            this.addTooltip(tooltip, (class_2561)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_catcher.min_health", this.getRequiredHealthPercentageToCapture() * 100.0f + "%"));
        }
        this.addTooltip(tooltip, (class_2561)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_catcher.usage_left", "(" + (itemStack.method_7936() - itemStack.method_7919()) + "/" + itemStack.method_7936() + ")").method_27692(class_124.field_1080));
    }
}

