/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.network.message.client;

import de.markusbordihn.easymobfarm.data.capture.MobCaptureCardDefinition;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureCardDefinitionManager;
import de.markusbordihn.easymobfarm.network.message.NetworkMessageRecord;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public record SyncMobCaptureCardDefinitionsMessage(Map<class_2960, MobCaptureCardDefinition> definitions) implements NetworkMessageRecord
{
    public static final class_2960 MESSAGE_ID = new class_2960("easy_mob_farm", "sync_mob_capture_card_definitions");

    public static SyncMobCaptureCardDefinitionsMessage create(class_2540 buffer) {
        int size = buffer.method_10816();
        HashMap<class_2960, MobCaptureCardDefinition> definitions = new HashMap<class_2960, MobCaptureCardDefinition>();
        for (int i = 0; i < size; ++i) {
            class_2960 entityId = buffer.method_10810();
            MobCaptureCardDefinition definition = MobCaptureCardDefinition.decode(buffer);
            definitions.put(entityId, definition);
        }
        return new SyncMobCaptureCardDefinitionsMessage(definitions);
    }

    @Override
    public void write(class_2540 buffer) {
        buffer.method_10804(this.definitions.size());
        for (Map.Entry<class_2960, MobCaptureCardDefinition> entry : this.definitions.entrySet()) {
            buffer.method_10812(entry.getKey());
            entry.getValue().encode(buffer);
        }
    }

    @Override
    public class_2960 id() {
        return MESSAGE_ID;
    }

    @Override
    public void handleClient() {
        if (this.definitions == null || this.definitions.isEmpty()) {
            log.warn("No mob capture card definitions to sync!");
            return;
        }
        log.info("Syncing {} mob capture card definitions to client.", (Object)this.definitions.size());
        MobCaptureCardDefinitionManager.setDefinitions(this.definitions);
    }
}

