/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import de.markusbordihn.easymobfarm.block.MobFarmBlock;
import de.markusbordihn.easymobfarm.block.entity.MobFarmBlockEntity;
import de.markusbordihn.easymobfarm.client.renderer.manager.EntityScalingManager;
import de.markusbordihn.easymobfarm.client.renderer.manager.RendererManager;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureCardDefinition;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureCardDefinitionManager;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MobFarmBlockEntityRenderer<T extends MobFarmBlockEntity>
implements BlockEntityRenderer<T> {
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");

    public MobFarmBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(T blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (!((MobFarmBlockEntity)((Object)blockEntity)).hasCapturedMob()) {
            RendererManager.removeEntity(blockEntity);
            return;
        }
        Entity entity = RendererManager.getOrCreateEntity(blockEntity);
        if (entity == null) {
            return;
        }
        try {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                this.renderLivingEntity(blockEntity, livingEntity, poseStack, buffer, combinedLight);
            } else if (entity instanceof Entity) {
                this.renderGenericEntity(blockEntity, entity, poseStack, buffer, combinedLight);
            }
        }
        catch (Exception livingException) {
            try {
                this.renderGenericEntity(blockEntity, entity, poseStack, buffer, combinedLight);
            }
            catch (Exception genericException) {
                log.error("Failed to render entity {} for block entity {} with exception: {}", (Object)entity.m_6095_(), (Object)blockEntity.m_58899_(), (Object)genericException.getMessage());
            }
        }
    }

    private void renderLivingEntity(T blockEntity, LivingEntity entity, PoseStack poseStack, MultiBufferSource buffer, int combinedLight) {
        EntityRenderDispatcher dispatcher = Minecraft.m_91087_().m_91290_();
        EntityRenderer renderer = dispatcher.m_114382_((Entity)entity);
        entity.f_19797_ = (int)blockEntity.m_58904_().m_46467_();
        MobCaptureCardDefinition mobCaptureCardDefinition = MobCaptureCardDefinitionManager.get(entity.m_6095_());
        if (mobCaptureCardDefinition != null && mobCaptureCardDefinition.requiresAnimationTick() && entity.f_19797_ % 2 == 0) {
            entity.m_8119_();
        }
        poseStack.m_85836_();
        this.prepareEntityPose(blockEntity, (Entity)entity, poseStack);
        renderer.m_7392_((Entity)entity, 0.0f, 0.0f, poseStack, buffer, combinedLight);
        poseStack.m_85849_();
    }

    private void renderGenericEntity(T blockEntity, Entity entity, PoseStack poseStack, MultiBufferSource buffer, int combinedLight) {
        EntityRenderDispatcher dispatcher = Minecraft.m_91087_().m_91290_();
        EntityRenderer renderer = dispatcher.m_114382_(entity);
        entity.f_19797_ = (int)blockEntity.m_58904_().m_46467_();
        poseStack.m_85836_();
        this.prepareEntityPose(blockEntity, entity, poseStack);
        renderer.m_7392_(entity, 0.0f, 0.0f, poseStack, buffer, combinedLight);
        poseStack.m_85849_();
    }

    private void prepareEntityPose(T blockEntity, Entity entity, PoseStack poseStack) {
        FlyingAnimal flyingAnimal;
        MobFarmType mobFarmType = ((MobFarmBlockEntity)((Object)blockEntity)).getFarmType();
        if (mobFarmType == MobFarmType.LUCKY_DROP_FARM) {
            poseStack.m_85837_(0.5, 0.19, 0.5);
        } else {
            poseStack.m_85837_(0.5, 0.08, 0.5);
        }
        float entityScaling = EntityScalingManager.getEntityScale(entity);
        if (mobFarmType == MobFarmType.LUCKY_DROP_FARM) {
            entityScaling *= 0.75f;
        }
        poseStack.m_85841_(entityScaling, entityScaling, entityScaling);
        float rotationDegrees = switch ((Direction)blockEntity.m_58900_().m_61143_((Property)MobFarmBlock.FACING)) {
            case Direction.NORTH -> 180.0f;
            case Direction.SOUTH -> 0.0f;
            case Direction.WEST -> -90.0f;
            case Direction.EAST -> 90.0f;
            default -> 0.0f;
        };
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(rotationDegrees));
        if (entity instanceof AbstractSchoolingFish) {
            poseStack.m_85837_(-0.1, 0.5, 0.1);
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(2.0f));
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(15.0f));
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(-90.0f));
        } else if (entity instanceof Bee) {
            poseStack.m_85837_(0.0, 0.5, 0.0);
        } else if (entity instanceof Squid) {
            poseStack.m_85837_(0.0, 1.3, 0.0);
        } else if (entity instanceof Phantom) {
            poseStack.m_85837_(0.0, 0.5, 0.0);
        } else if (entity instanceof FlyingMob || entity instanceof FlyingAnimal && (flyingAnimal = (FlyingAnimal)entity).m_29443_() || entity instanceof Guardian) {
            poseStack.m_85837_(0.0, 0.3 / (double)entityScaling, 0.0);
        } else if (entity instanceof EnderDragon) {
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(0.0f));
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(0.0f));
        }
    }
}

