/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.menu;

import de.markusbordihn.easymobfarm.block.entity.MobFarmBlockEntity;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmDataEntry;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmSlot;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmSlots;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmType;
import de.markusbordihn.easymobfarm.item.upgrade.slot.BigSlotUpgradeItem;
import de.markusbordihn.easymobfarm.item.upgrade.slot.SmallSlotUpgradeItem;
import de.markusbordihn.easymobfarm.menu.slots.CapturedMobSlot;
import de.markusbordihn.easymobfarm.menu.slots.EnhancementSlot;
import de.markusbordihn.easymobfarm.menu.slots.FilterSlot;
import de.markusbordihn.easymobfarm.menu.slots.OutputSlot;
import de.markusbordihn.easymobfarm.menu.slots.SlotUpgradeSlot;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MobFarmMenu
extends AbstractContainerMenu {
    public static final String ID = "mob_farm_menu";
    public static final int CAPTURED_MOB_SLOT_X = 121;
    public static final int CAPTURED_MOB_SLOT_Y = 39;
    public static final int UPGRADE_SLOT_X = 156;
    public static final int UPGRADE_SLOT_Y = 32;
    public static final int FILTER_SLOT_X = 219;
    public static final int FILTER_SLOT_Y = 14;
    public static final int SLOT_UPGRADE_SLOT_X = 20;
    public static final int SLOT_UPGRADE_SLOT_Y = 89;
    public static final int RESULT_SLOT_X = 48;
    public static final int RESULT_SLOT_Y = 89;
    public static final int PLAYER_INVENTORY_SLOT_X = 48;
    public static final int PLAYER_INVENTORY_SLOT_Y = 157;
    public static final int PLAYER_HOTBAR_SLOT_X = 48;
    public static final int PLAYER_HOTBAR_SLOT_Y = 215;
    public static final int CONTAINER_SIZE = 52;
    public static final int CONTAINER_DATA_SIZE = MobFarmDataEntry.getLastSlotIndex() + 1;
    public static final int MIN_NUMBER_OF_OUTPUT_SLOTS = 6;
    public static final int MAX_NUMBER_OF_OUTPUT_SLOTS = 27;
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private final Container container;
    private final ContainerData data;
    private final Inventory playerInventory;

    public MobFarmMenu(MenuType<?> menuType, int containerId, Inventory playerInventory) {
        this(menuType, containerId, playerInventory, (Container)new SimpleContainer(52), (ContainerData)new SimpleContainerData(CONTAINER_DATA_SIZE));
    }

    public MobFarmMenu(MenuType<?> menuType, int containerId, Inventory playerInventory, Container container, ContainerData containerData) {
        super(menuType, containerId);
        MobFarmMenu.m_38869_((Container)container, (int)52);
        MobFarmMenu.m_38886_((ContainerData)containerData, (int)CONTAINER_DATA_SIZE);
        this.container = container;
        this.data = containerData;
        this.playerInventory = playerInventory;
        this.defineMobFarmSlots();
        this.defineUpgradeSlots();
        this.defineFilterSlots();
        this.defineSlotUpgradeSlots();
        this.defineOuputSlots();
        this.definePlayerInventorySlots();
        this.definePlayerHotbarSlots();
        Container container2 = this.container;
        if (container2 instanceof MobFarmBlockEntity) {
            MobFarmBlockEntity mobFarmBlockEntity = (MobFarmBlockEntity)container2;
            BlockPos blockPos = mobFarmBlockEntity.m_58899_();
            if (this.getMobFarmBlockPos() == null || !this.getMobFarmBlockPos().equals((Object)blockPos)) {
                log.debug("Update Block pose {} for {}", (Object)blockPos, (Object)mobFarmBlockEntity);
                this.setMobFarmBlockPos(blockPos);
            }
            if (this.updateNumberOfOutputSlots()) {
                log.debug("Update number of output slots {} for {}", (Object)this.getMobFarmNumberOfOutputSlots(), (Object)mobFarmBlockEntity);
            }
        }
        this.m_38884_(containerData);
    }

    public BlockPos getMobFarmBlockPos() {
        return new BlockPos(this.data.m_6413_(0), this.data.m_6413_(1), this.data.m_6413_(2));
    }

    public void setMobFarmBlockPos(BlockPos blockPos) {
        this.data.m_8050_(0, blockPos.m_123341_());
        this.data.m_8050_(1, blockPos.m_123342_());
        this.data.m_8050_(2, blockPos.m_123343_());
    }

    public int getMobFarmNumberOfOutputSlots() {
        return this.data.m_6413_(3);
    }

    public void setMobFarmNumberOfOutputSlots(int numberOfOutputSlots) {
        this.data.m_8050_(3, numberOfOutputSlots);
    }

    public int getMobFarmProgress() {
        return this.data.m_6413_(4);
    }

    public int getMobFarmProgressionSpeed() {
        return this.data.m_6413_(9);
    }

    public int getMobFarmProgressionSpeedBonus() {
        return this.data.m_6413_(10);
    }

    public int getMobFarmStatus() {
        return this.data.m_6413_(5);
    }

    public int getMobFarmTierLevel() {
        return this.data.m_6413_(6);
    }

    public MobFarmType getMobFarmType() {
        int mobFarmTypeIndex = this.data.m_6413_(7);
        return mobFarmTypeIndex >= 0 ? MobFarmType.values()[this.data.m_6413_(7)] : null;
    }

    public int getCapturedMobExperience() {
        return this.data.m_6413_(8);
    }

    private void defineMobFarmSlots() {
        this.m_38897_(new CapturedMobSlot(this.container, MobFarmSlot.CAPTURED_MOB.index(), 121, 39));
    }

    private void defineUpgradeSlots() {
        int slotId = 0;
        for (int row = 0; row < 2; ++row) {
            for (int column = 0; column < 2; ++column) {
                this.m_38897_(new EnhancementSlot(this.container, MobFarmSlots.ENHANCEMENT_ITEM_SLOTS.get(slotId).index(), 156 + column * 18, 32 + row * 18));
                ++slotId;
            }
        }
    }

    private void defineFilterSlots() {
        int slotId = 0;
        for (int row = 0; row < 4; ++row) {
            this.m_38897_(new FilterSlot(this.container, MobFarmSlots.FILTER_ITEM_SLOTS.get(slotId).index(), 219, 14 + row * 18));
            ++slotId;
        }
    }

    private void defineSlotUpgradeSlots() {
        int slotId = 0;
        for (int row = 0; row < 3; ++row) {
            this.m_38897_(new SlotUpgradeSlot(this, this.container, MobFarmSlots.SLOT_UPGRADE_ITEM_SLOTS.get(slotId).index(), 20, 89 + row * 18));
            ++slotId;
        }
    }

    private void defineOuputSlots() {
        int slotId = 0;
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.m_38897_(new OutputSlot(this.container, MobFarmSlots.RESULT_SLOTS.get(slotId).index(), 48 + column * 18, 89 + row * 18));
                ++slotId;
            }
        }
    }

    private void definePlayerInventorySlots() {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.m_38897_(new Slot((Container)this.playerInventory, column + row * 9 + 9, 48 + column * 18, 157 + row * 18));
            }
        }
    }

    private void definePlayerHotbarSlots() {
        for (int column = 0; column < 9; ++column) {
            this.m_38897_(new Slot((Container)this.playerInventory, column, 48 + column * 18, 215));
        }
    }

    private boolean updateNumberOfOutputSlots() {
        int newNumberOfOutputSlots;
        int numberOfOutputSlots = 6;
        for (Slot slot : this.f_38839_) {
            if (!(slot instanceof SlotUpgradeSlot) || !slot.m_6657_() || slot.m_7993_().m_41619_()) continue;
            Item item = slot.m_7993_().m_41720_();
            if (item instanceof SmallSlotUpgradeItem) {
                SmallSlotUpgradeItem smallSlotUpgradeItem = (SmallSlotUpgradeItem)item;
                numberOfOutputSlots += smallSlotUpgradeItem.numberOfUpgradeSlots();
                continue;
            }
            item = slot.m_7993_().m_41720_();
            if (!(item instanceof BigSlotUpgradeItem)) continue;
            BigSlotUpgradeItem bigSlotUpgradeItem = (BigSlotUpgradeItem)item;
            numberOfOutputSlots += bigSlotUpgradeItem.numberOfUpgradeSlots();
        }
        int currentNumberOfOutputSlots = this.getMobFarmNumberOfOutputSlots();
        if (currentNumberOfOutputSlots != (newNumberOfOutputSlots = Math.min(Math.max(6, numberOfOutputSlots), 27))) {
            this.setMobFarmNumberOfOutputSlots(newNumberOfOutputSlots);
            this.adjustOutputSlots(newNumberOfOutputSlots);
            return true;
        }
        return false;
    }

    private void adjustOutputSlots(int maxNumberOfOutputSlots) {
        int currentNumberOfOutputSlots = 0;
        for (Slot slot : this.f_38839_) {
            if (!(slot instanceof OutputSlot)) continue;
            OutputSlot outputSlot = (OutputSlot)slot;
            outputSlot.setActive(currentNumberOfOutputSlots++ < maxNumberOfOutputSlots);
        }
    }

    public void slotUpgradeChanged(SlotUpgradeSlot slot) {
        this.updateNumberOfOutputSlots();
    }

    public boolean m_6875_(Player player) {
        return player.m_6084_();
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack itemStack = slot.m_7993_();
        ItemStack itemStackCopy = itemStack.m_41777_();
        if (slot.f_40218_ == this.container) {
            if (!this.m_38903_(itemStack, 36, this.f_38839_.size(), true)) {
                return ItemStack.f_41583_;
            }
        } else if (slot.f_40218_ == this.playerInventory) {
            for (Slot targetSlot : this.f_38839_.subList(0, MobFarmSlots.RESULT_SLOTS.size())) {
                if (targetSlot instanceof OutputSlot || targetSlot.m_6657_() || !targetSlot.m_5857_(itemStack)) continue;
                ItemStack singleItem = itemStack.m_41620_(1);
                targetSlot.m_5852_(singleItem);
                targetSlot.m_6654_();
                break;
            }
        }
        if (itemStack.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        if (itemStack.m_41613_() == itemStackCopy.m_41613_()) {
            return ItemStack.f_41583_;
        }
        slot.m_142406_(player, itemStack);
        return itemStackCopy;
    }
}

