/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.data.capture;

import de.markusbordihn.easymobfarm.compat.CompatConstants;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1451;
import net.minecraft.class_1589;
import net.minecraft.class_1621;
import net.minecraft.class_1646;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_7102;
import net.minecraft.class_7106;
import net.minecraft.class_7375;

public class MobVariantData {
    public static final String VARIANT_TAG = "Variant";
    public static final String LARGE_VARIANT = "large";
    public static final String MEDIUM_VARIANT = "medium";
    public static final String SMALL_VARIANT = "small";
    public static final String TINY_VARIANT = "tiny";
    private static final Map<class_7375, String> CAT_VARIANT_MAP = new HashMap<class_7375, String>();
    private static final Map<class_7106, String> FROG_VARIANT_MAP = new HashMap<class_7106, String>();
    private static final Map<class_2960, String> SWAMPIER_SWAMPS_FROG_VARIANT_MAP = new HashMap<class_2960, String>();

    private MobVariantData() {
    }

    public static String getVariant(class_1299<?> entityType) {
        return null;
    }

    public static String getVariant(class_1309 livingEntity) {
        if (livingEntity instanceof class_1451) {
            class_1451 cat = (class_1451)livingEntity;
            return CAT_VARIANT_MAP.get(cat.method_6571());
        }
        if (livingEntity instanceof class_1646) {
            class_1646 villager = (class_1646)livingEntity;
            return villager.method_7231().method_16924().comp_818();
        }
        if (livingEntity instanceof class_1589) {
            class_1589 magmaCube = (class_1589)livingEntity;
            return MobVariantData.getSizeVariant(magmaCube.method_7152());
        }
        if (livingEntity instanceof class_1621) {
            class_1621 slime = (class_1621)livingEntity;
            return MobVariantData.getSizeVariant(slime.method_7152());
        }
        if (livingEntity instanceof class_7102) {
            class_7102 frog = (class_7102)livingEntity;
            String frogVariant = FROG_VARIANT_MAP.get(frog.method_41354());
            if (frogVariant != null) {
                return frogVariant;
            }
            if (CompatConstants.MOD_SWAMPIER_SWAMPS_LOADED) {
                return SWAMPIER_SWAMPS_FROG_VARIANT_MAP.get(frog.method_41354().comp_707());
            }
        }
        return null;
    }

    public static String getVariant(class_2487 compoundTag) {
        if (compoundTag == null) {
            return null;
        }
        if (compoundTag.method_10545(VARIANT_TAG)) {
            return compoundTag.method_10558(VARIANT_TAG);
        }
        if (compoundTag.method_10545(VARIANT_TAG.toLowerCase(Locale.ROOT))) {
            return compoundTag.method_10558(VARIANT_TAG.toLowerCase(Locale.ROOT));
        }
        return null;
    }

    public static String getSizeVariant(float size) {
        if (size <= 1.0f) {
            return TINY_VARIANT;
        }
        if (size <= 2.0f) {
            return SMALL_VARIANT;
        }
        if (size < 4.0f) {
            return MEDIUM_VARIANT;
        }
        if (size >= 4.0f) {
            return LARGE_VARIANT;
        }
        return "";
    }

    public static class_7375 getCatVariant(String variant) {
        for (Map.Entry<class_7375, String> entry : CAT_VARIANT_MAP.entrySet()) {
            if (!entry.getValue().equals(variant)) continue;
            return entry.getKey();
        }
        return class_7375.field_38710;
    }

    public static class_7106 getFrogVariant(String variant) {
        for (Map.Entry<class_7106, String> entry : FROG_VARIANT_MAP.entrySet()) {
            if (!entry.getValue().equals(variant)) continue;
            return entry.getKey();
        }
        if (CompatConstants.MOD_SWAMPIER_SWAMPS_LOADED) {
            try {
                class_2960 resourceLocation = new class_2960("swampier_swamps", variant + "_variant");
                if (class_2378.field_38805.method_10250(resourceLocation)) {
                    return (class_7106)class_2378.field_38805.method_10223(resourceLocation);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            switch (variant) {
                case "orange": {
                    return class_7106.field_37462;
                }
                case "light_gray": {
                    return class_7106.field_37463;
                }
                case "green": {
                    return class_7106.field_37464;
                }
            }
        }
        return class_7106.field_37462;
    }

    static {
        CAT_VARIANT_MAP.put(class_7375.field_38709, "tabby");
        CAT_VARIANT_MAP.put(class_7375.field_38710, "black");
        CAT_VARIANT_MAP.put(class_7375.field_38711, "red");
        CAT_VARIANT_MAP.put(class_7375.field_38712, "siamese");
        CAT_VARIANT_MAP.put(class_7375.field_38713, "british_shorthair");
        CAT_VARIANT_MAP.put(class_7375.field_38714, "calico");
        CAT_VARIANT_MAP.put(class_7375.field_38715, "persian");
        CAT_VARIANT_MAP.put(class_7375.field_38716, "ragdoll");
        CAT_VARIANT_MAP.put(class_7375.field_38717, "white");
        CAT_VARIANT_MAP.put(class_7375.field_38718, "jellie");
        CAT_VARIANT_MAP.put(class_7375.field_38719, "all_black");
        FROG_VARIANT_MAP.put(class_7106.field_37464, "cold");
        FROG_VARIANT_MAP.put(class_7106.field_37463, "warm");
        FROG_VARIANT_MAP.put(class_7106.field_37462, "temperate");
        if (CompatConstants.MOD_SWAMPIER_SWAMPS_LOADED) {
            SWAMPIER_SWAMPS_FROG_VARIANT_MAP.put(new class_2960("swampier_swamps", "textures/entity/frog/frog_white.png"), "white");
            SWAMPIER_SWAMPS_FROG_VARIANT_MAP.put(new class_2960("swampier_swamps", "textures/entity/frog/frog_magenta.png"), "magenta");
            SWAMPIER_SWAMPS_FROG_VARIANT_MAP.put(new class_2960("swampier_swamps", "textures/entity/frog/frog_light_blue.png"), "light_blue");
            SWAMPIER_SWAMPS_FROG_VARIANT_MAP.put(new class_2960("swampier_swamps", "textures/entity/frog/frog_yellow.png"), "yellow");
            SWAMPIER_SWAMPS_FROG_VARIANT_MAP.put(new class_2960("swampier_swamps", "textures/entity/frog/frog_lime.png"), "lime");
            SWAMPIER_SWAMPS_FROG_VARIANT_MAP.put(new class_2960("swampier_swamps", "textures/entity/frog/frog_pink.png"), "pink");
            SWAMPIER_SWAMPS_FROG_VARIANT_MAP.put(new class_2960("swampier_swamps", "textures/entity/frog/frog_gray.png"), "gray");
            SWAMPIER_SWAMPS_FROG_VARIANT_MAP.put(new class_2960("swampier_swamps", "textures/entity/frog/frog_cyan.png"), "cyan");
            SWAMPIER_SWAMPS_FROG_VARIANT_MAP.put(new class_2960("swampier_swamps", "textures/entity/frog/frog_purple.png"), "purple");
            SWAMPIER_SWAMPS_FROG_VARIANT_MAP.put(new class_2960("swampier_swamps", "textures/entity/frog/frog_blue.png"), "blue");
            SWAMPIER_SWAMPS_FROG_VARIANT_MAP.put(new class_2960("swampier_swamps", "textures/entity/frog/frog_brown.png"), "brown");
            SWAMPIER_SWAMPS_FROG_VARIANT_MAP.put(new class_2960("swampier_swamps", "textures/entity/frog/frog_red.png"), "red");
            SWAMPIER_SWAMPS_FROG_VARIANT_MAP.put(new class_2960("swampier_swamps", "textures/entity/frog/frog_black.png"), "black");
        }
    }
}

