/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.entity;

import de.markusbordihn.easymobfarm.capture.MobCaptureManager;
import de.markusbordihn.easymobfarm.config.MobCaptureCardConfig;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3489;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FishingEvents {
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private static final Random RANDOM = new Random();

    private FishingEvents() {
    }

    public static void handleItemFishedEvent(class_3222 serverPlayer, List<class_1799> lootList) {
        if (!MobCaptureCardConfig.dropMobCaptureCardOnFishing) {
            return;
        }
        class_1792 fishLoot = null;
        for (class_1799 itemStack : lootList) {
            if (itemStack.method_7960() || !itemStack.method_31573(class_3489.field_15527)) continue;
            fishLoot = itemStack.method_7909();
            break;
        }
        if (fishLoot == null) {
            return;
        }
        class_2960 resourceLocation = class_2378.field_11142.method_10221(fishLoot);
        class_1299 entityType = (class_1299)class_2378.field_11145.method_10223(resourceLocation);
        if (entityType == null) {
            return;
        }
        String entityName = class_2378.field_11145.method_10221((Object)entityType).toString();
        if (MobCaptureCardConfig.mobCaptureCardFishingDropDenyList.contains(entityName) || !MobCaptureCardConfig.mobCaptureCardFishingDropAllowList.isEmpty() && !MobCaptureCardConfig.mobCaptureCardFishingDropAllowList.contains(entityName)) {
            log.debug("[Skip] Mob capture card fishing drop for {}.", (Object)entityName);
            return;
        }
        if (MobCaptureCardConfig.mobCaptureCardFishingDropChance > 0.0f && RANDOM.nextFloat() > MobCaptureCardConfig.mobCaptureCardFishingDropChance) {
            return;
        }
        class_1799 itemStack = MobCaptureManager.getMobCaptureCardItem(entityType, (class_1937)serverPlayer.method_14220());
        if (itemStack != null) {
            log.debug("Dropped mob capture card {} for {}.", (Object)itemStack, (Object)entityType);
            serverPlayer.method_5699(itemStack, 0.5f);
        } else {
            log.error("Failed to drop mob capture card for {}.", (Object)entityType);
        }
    }
}

