/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.experience;

import de.markusbordihn.easymobfarm.experience.ExperienceManagerInterface;
import net.minecraft.class_1309;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExperienceManager {
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private static final String LOG_PREFIX = "[Experience Manager]";
    private static ExperienceManagerInterface experienceManagerInterface;

    private ExperienceManager() {
    }

    public static void registerExperienceManager(ExperienceManagerInterface experienceManagerInterface) {
        log.info("{} Experience Manager {}", (Object)"Register Easy Mob Farm", (Object)experienceManagerInterface.getClass().getSimpleName());
        ExperienceManager.experienceManagerInterface = experienceManagerInterface;
    }

    public static ExperienceManagerInterface getExperienceManager() {
        return experienceManagerInterface;
    }

    public static int getExperienceReward(class_1309 livingEntity) {
        try {
            return experienceManagerInterface.getExperienceReward(livingEntity);
        }
        catch (Exception e) {
            log.error("{} Failed to get experience reward for {}", (Object)LOG_PREFIX, (Object)livingEntity.getClass().getSimpleName(), (Object)e);
            return 0;
        }
    }

    public static boolean shouldDropExperience(class_1309 livingEntity) {
        if (experienceManagerInterface != null) {
            return experienceManagerInterface.shouldDropExperience(livingEntity);
        }
        return false;
    }
}

