/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.item;

import de.markusbordihn.easymobfarm.config.MobCatcherConfig;
import de.markusbordihn.easymobfarm.config.MobFarmConfig;
import java.util.Collection;
import net.minecraft.class_1860;
import net.minecraft.class_2596;
import net.minecraft.class_2788;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModRecipeManager {
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private static final String LOG_PREFIX = "[Recipe Manager]";
    private static final String MOB_CAPTURE_PREFIX = "mob_catcher/";
    private static final String MOB_FARM_TEMPLATE_PREFIX = "mob_farm_template/";

    private ModRecipeManager() {
    }

    public static void register(MinecraftServer minecraftServer) {
        log.info("{} Mod Recipe Manager ...", (Object)"Register Easy Mob Farm");
        Collection recipes = minecraftServer.method_3772().method_8126();
        ModRecipeManager.removeRecipeIfDisabled(recipes, MobCatcherConfig.ENDURING_CAPTURE_NET_ENABLED, "enduring_capture_net", MOB_CAPTURE_PREFIX);
        ModRecipeManager.removeRecipeIfDisabled(recipes, MobCatcherConfig.IRONBOUND_CONTAINMENT_CAGE_ENABLED, "ironbound_containment_cage", MOB_CAPTURE_PREFIX);
        ModRecipeManager.removeRecipeIfDisabled(recipes, MobCatcherConfig.MYSTIC_BINDING_CRYSTAL_ENABLED, "mystic_binding_crystal", MOB_CAPTURE_PREFIX);
        ModRecipeManager.removeRecipeIfDisabled(recipes, MobCatcherConfig.VOID_BINDING_CHAIN_ENABLED, "void_binding_chain", MOB_CAPTURE_PREFIX);
        ModRecipeManager.removeRecipeIfDisabled(recipes, !MobFarmConfig.enforceLogicalTierProgression, "tier1_mob_farm_template", MOB_FARM_TEMPLATE_PREFIX);
        ModRecipeManager.removeRecipeIfDisabled(recipes, !MobFarmConfig.enforceLogicalTierProgression, "tier2_mob_farm_template", MOB_FARM_TEMPLATE_PREFIX);
        ModRecipeManager.removeRecipeIfDisabled(recipes, !MobFarmConfig.enforceLogicalTierProgression, "tier3_mob_farm_template", MOB_FARM_TEMPLATE_PREFIX);
        if (minecraftServer.method_3772().method_8126().size() != recipes.size()) {
            log.info("Updating recipes with adjusted recipes ...");
            minecraftServer.method_3772().method_20702((Iterable)recipes);
            for (class_3222 player : minecraftServer.method_3760().method_14571()) {
                log.info("{} Sync recipe to player {} ...", (Object)LOG_PREFIX, (Object)player.method_5477().getString());
                player.field_13987.method_14364((class_2596)new class_2788(minecraftServer.method_3772().method_8126()));
            }
            minecraftServer.method_3772().method_8126().forEach(recipe -> log.debug("{} Loaded recipe: {}", (Object)LOG_PREFIX, (Object)recipe.method_8114()));
        }
    }

    private static boolean removeRecipeIfDisabled(Collection<class_1860<?>> recipes, boolean isEnabled, String itemId, String recipePrefix) {
        if (isEnabled) {
            return false;
        }
        String recipePath = recipePrefix + itemId;
        boolean removed = recipes.removeIf(recipe -> recipe.method_8114().method_12836().equals("easy_mob_farm") && recipe.method_8114().method_12832().equals(recipePath));
        if (removed) {
            log.info("{} Removed {} recipe ...", (Object)LOG_PREFIX, (Object)recipePath);
        } else {
            log.error("{} Failed to deactivate recipe {} !", (Object)LOG_PREFIX, (Object)recipePath);
        }
        return removed;
    }
}

