/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.item.mobcapturecard;

import de.markusbordihn.easymobfarm.capture.MobCaptureManager;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureData;
import de.markusbordihn.easymobfarm.network.components.TextComponent;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class MobCaptureCardItem
extends class_1792 {
    public static final String ID = "mob_capture_card";
    public static final class_2960 RESOURCE_LOCATION = new class_2960("easy_mob_farm", "mob_capture_card");
    public static final String TOOLTIP_PREFIX = "tooltip.easy_mob_farm.mob_capture_card.";

    public MobCaptureCardItem() {
        this(new class_1792.class_1793());
    }

    public MobCaptureCardItem(class_1792.class_1793 properties) {
        super(properties.method_24359());
    }

    public static MobCaptureCardItem getMobCaptureCardItem() {
        Object object = class_2378.field_11142.method_10223(RESOURCE_LOCATION);
        if (object instanceof MobCaptureCardItem) {
            MobCaptureCardItem mobCaptureCardItem = (MobCaptureCardItem)((Object)object);
            return mobCaptureCardItem;
        }
        return null;
    }

    private static String getVariantName(String variant) {
        if (variant == null || variant.isEmpty()) {
            return "";
        }
        return Arrays.stream(variant.split("_")).map(word -> word.substring(0, 1).toUpperCase(Locale.ROOT) + word.substring(1).toLowerCase(Locale.ROOT)).collect(Collectors.joining(" "));
    }

    private static class_2561 getTranslatedEntityName(MobCaptureData mobCaptureData) {
        if (mobCaptureData == null || mobCaptureData.name() == null) {
            return TextComponent.getText("Unknown");
        }
        return TextComponent.getTranslatedTextRaw(mobCaptureData.name());
    }

    private static void addSpecialMechanicsTooltips(MobCaptureData mobCaptureData, List<class_2561> tooltip) {
        if (mobCaptureData == null || mobCaptureData.name() == null) {
            return;
        }
        class_5250 specialMechanicsTooltip = MobCaptureCardItem.tryGetTranslation(TOOLTIP_PREFIX + mobCaptureData.name().replace("entity.", "").replace(":", ".") + ".special_mechanics");
        if (specialMechanicsTooltip != null) {
            tooltip.add((class_2561)specialMechanicsTooltip.method_27692(class_124.field_1080));
        }
    }

    private static class_5250 tryGetTranslation(String translationKey) {
        try {
            class_5250 translation = TextComponent.getTranslatedTextRaw(translationKey);
            if (translation.getString().equals(translationKey)) {
                return null;
            }
            return translation;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean method_7870(class_1799 itemStack) {
        return false;
    }

    public boolean method_24358() {
        return true;
    }

    public boolean method_7885(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player) {
        return false;
    }

    public class_2561 method_7864(class_1799 itemStack) {
        MobCaptureData mobCaptureData = MobCaptureManager.getMobCaptureData(itemStack);
        if (mobCaptureData == null) {
            return super.method_7864(itemStack);
        }
        Object key = "tooltip.easy_mob_farm.mob_capture_card.card_name";
        Object[] args = new Object[]{MobCaptureCardItem.getTranslatedEntityName(mobCaptureData)};
        if (mobCaptureData.variant() != null && !mobCaptureData.name().equalsIgnoreCase(mobCaptureData.variant())) {
            if (mobCaptureData.color() != null) {
                key = (String)key + "_variant_color";
                args = new Object[]{MobCaptureCardItem.getTranslatedEntityName(mobCaptureData), MobCaptureCardItem.getVariantName(mobCaptureData.variant()), mobCaptureData.color().method_7792()};
            } else {
                key = (String)key + "_variant";
                args = new Object[]{MobCaptureCardItem.getTranslatedEntityName(mobCaptureData), MobCaptureCardItem.getVariantName(mobCaptureData.variant())};
            }
        } else if (mobCaptureData.color() != null) {
            key = (String)key + "_color";
            args = new Object[]{MobCaptureCardItem.getTranslatedEntityName(mobCaptureData), mobCaptureData.color().method_7792()};
        }
        return TextComponent.getTranslatedTextRaw((String)key, args).method_27693(" ").method_10852((class_2561)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_capture_card").method_27692(class_124.field_1080));
    }

    public class_1814 method_7862(class_1799 itemStack) {
        MobCaptureData mobCaptureData = MobCaptureManager.getMobCaptureData(itemStack);
        return mobCaptureData != null ? mobCaptureData.rarity() : class_1814.field_8906;
    }

    public boolean method_7886(class_1799 itemStack) {
        MobCaptureData mobCaptureData = MobCaptureManager.getMobCaptureData(itemStack);
        return mobCaptureData != null && mobCaptureData.isFoil();
    }

    public void method_7851(class_1799 itemStack, class_1937 world, List<class_2561> tooltip, class_1836 flag) {
        MobCaptureData mobCaptureData = MobCaptureManager.getMobCaptureData(itemStack);
        if (mobCaptureData == null) {
            tooltip.add((class_2561)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_capture_card.empty"));
            return;
        }
        tooltip.add((class_2561)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_capture_card.name", MobCaptureCardItem.getTranslatedEntityName(mobCaptureData)));
        if (flag.method_8035()) {
            tooltip.add((class_2561)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_capture_card.description_id", mobCaptureData.name()));
            tooltip.add((class_2561)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_capture_card.type", mobCaptureData.type()));
        }
        if (mobCaptureData.variant() != null) {
            tooltip.add((class_2561)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_capture_card.variant", mobCaptureData.variant()));
        }
        if (mobCaptureData.color() != null) {
            tooltip.add((class_2561)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_capture_card.color", mobCaptureData.color().method_7792()));
        }
        class_124 rarityColor = switch (mobCaptureData.rarity()) {
            case class_1814.field_8907 -> class_124.field_1060;
            case class_1814.field_8903 -> class_124.field_1078;
            case class_1814.field_8904 -> class_124.field_1064;
            default -> class_124.field_1080;
        };
        tooltip.add((class_2561)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_capture_card.rarity", mobCaptureData.rarity().name()).method_27692(rarityColor));
        tooltip.add((class_2561)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_capture_card.id", String.valueOf(mobCaptureData.getCardId())));
        MobCaptureCardItem.addSpecialMechanicsTooltips(mobCaptureData, tooltip);
    }
}

