/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.menu;

import de.markusbordihn.easymobfarm.block.entity.MobFarmBlockEntity;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmDataEntry;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmSlot;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmSlots;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmType;
import de.markusbordihn.easymobfarm.item.upgrade.slot.BigSlotUpgradeItem;
import de.markusbordihn.easymobfarm.item.upgrade.slot.SmallSlotUpgradeItem;
import de.markusbordihn.easymobfarm.menu.slots.CapturedMobSlot;
import de.markusbordihn.easymobfarm.menu.slots.EnhancementSlot;
import de.markusbordihn.easymobfarm.menu.slots.FilterSlot;
import de.markusbordihn.easymobfarm.menu.slots.OutputSlot;
import de.markusbordihn.easymobfarm.menu.slots.SlotUpgradeSlot;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_3913;
import net.minecraft.class_3917;
import net.minecraft.class_3919;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MobFarmMenu
extends class_1703 {
    public static final String ID = "mob_farm_menu";
    public static final int CAPTURED_MOB_SLOT_X = 121;
    public static final int CAPTURED_MOB_SLOT_Y = 39;
    public static final int UPGRADE_SLOT_X = 156;
    public static final int UPGRADE_SLOT_Y = 32;
    public static final int FILTER_SLOT_X = 219;
    public static final int FILTER_SLOT_Y = 14;
    public static final int SLOT_UPGRADE_SLOT_X = 20;
    public static final int SLOT_UPGRADE_SLOT_Y = 89;
    public static final int RESULT_SLOT_X = 48;
    public static final int RESULT_SLOT_Y = 89;
    public static final int PLAYER_INVENTORY_SLOT_X = 48;
    public static final int PLAYER_INVENTORY_SLOT_Y = 157;
    public static final int PLAYER_HOTBAR_SLOT_X = 48;
    public static final int PLAYER_HOTBAR_SLOT_Y = 215;
    public static final int CONTAINER_SIZE = 52;
    public static final int CONTAINER_DATA_SIZE = MobFarmDataEntry.getLastSlotIndex() + 1;
    public static final int MIN_NUMBER_OF_OUTPUT_SLOTS = 6;
    public static final int MAX_NUMBER_OF_OUTPUT_SLOTS = 27;
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private final class_1263 container;
    private final class_3913 data;
    private final class_1661 playerInventory;

    public MobFarmMenu(class_3917<?> menuType, int containerId, class_1661 playerInventory) {
        this(menuType, containerId, playerInventory, (class_1263)new class_1277(52), (class_3913)new class_3919(CONTAINER_DATA_SIZE));
    }

    public MobFarmMenu(class_3917<?> menuType, int containerId, class_1661 playerInventory, class_1263 container, class_3913 containerData) {
        super(menuType, containerId);
        MobFarmMenu.method_17359((class_1263)container, (int)52);
        MobFarmMenu.method_17361((class_3913)containerData, (int)CONTAINER_DATA_SIZE);
        this.container = container;
        this.data = containerData;
        this.playerInventory = playerInventory;
        this.defineMobFarmSlots();
        this.defineUpgradeSlots();
        this.defineFilterSlots();
        this.defineSlotUpgradeSlots();
        this.defineOuputSlots();
        this.definePlayerInventorySlots();
        this.definePlayerHotbarSlots();
        class_1263 class_12632 = this.container;
        if (class_12632 instanceof MobFarmBlockEntity) {
            MobFarmBlockEntity mobFarmBlockEntity = (MobFarmBlockEntity)class_12632;
            class_2338 blockPos = mobFarmBlockEntity.method_11016();
            if (this.getMobFarmBlockPos() == null || !this.getMobFarmBlockPos().equals((Object)blockPos)) {
                log.debug("Update Block pose {} for {}", (Object)blockPos, (Object)mobFarmBlockEntity);
                this.setMobFarmBlockPos(blockPos);
            }
            if (this.updateNumberOfOutputSlots()) {
                log.debug("Update number of output slots {} for {}", (Object)this.getMobFarmNumberOfOutputSlots(), (Object)mobFarmBlockEntity);
            }
        }
        this.method_17360(containerData);
    }

    public class_2338 getMobFarmBlockPos() {
        return new class_2338(this.data.method_17390(0), this.data.method_17390(1), this.data.method_17390(2));
    }

    public void setMobFarmBlockPos(class_2338 blockPos) {
        this.data.method_17391(0, blockPos.method_10263());
        this.data.method_17391(1, blockPos.method_10264());
        this.data.method_17391(2, blockPos.method_10260());
    }

    public int getMobFarmNumberOfOutputSlots() {
        return this.data.method_17390(3);
    }

    public void setMobFarmNumberOfOutputSlots(int numberOfOutputSlots) {
        this.data.method_17391(3, numberOfOutputSlots);
    }

    public int getMobFarmProgress() {
        return this.data.method_17390(4);
    }

    public int getMobFarmProgressionSpeed() {
        return this.data.method_17390(9);
    }

    public int getMobFarmProgressionSpeedBonus() {
        return this.data.method_17390(10);
    }

    public int getMobFarmStatus() {
        return this.data.method_17390(5);
    }

    public int getMobFarmTierLevel() {
        return this.data.method_17390(6);
    }

    public MobFarmType getMobFarmType() {
        int mobFarmTypeIndex = this.data.method_17390(7);
        return mobFarmTypeIndex >= 0 ? MobFarmType.values()[this.data.method_17390(7)] : null;
    }

    public int getCapturedMobExperience() {
        return this.data.method_17390(8);
    }

    private void defineMobFarmSlots() {
        this.method_7621(new CapturedMobSlot(this.container, MobFarmSlot.CAPTURED_MOB.index(), 121, 39));
    }

    private void defineUpgradeSlots() {
        int slotId = 0;
        for (int row = 0; row < 2; ++row) {
            for (int column = 0; column < 2; ++column) {
                this.method_7621(new EnhancementSlot(this.container, MobFarmSlots.ENHANCEMENT_ITEM_SLOTS.get(slotId).index(), 156 + column * 18, 32 + row * 18));
                ++slotId;
            }
        }
    }

    private void defineFilterSlots() {
        int slotId = 0;
        for (int row = 0; row < 4; ++row) {
            this.method_7621(new FilterSlot(this.container, MobFarmSlots.FILTER_ITEM_SLOTS.get(slotId).index(), 219, 14 + row * 18));
            ++slotId;
        }
    }

    private void defineSlotUpgradeSlots() {
        int slotId = 0;
        for (int row = 0; row < 3; ++row) {
            this.method_7621(new SlotUpgradeSlot(this, this.container, MobFarmSlots.SLOT_UPGRADE_ITEM_SLOTS.get(slotId).index(), 20, 89 + row * 18));
            ++slotId;
        }
    }

    private void defineOuputSlots() {
        int slotId = 0;
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.method_7621(new OutputSlot(this.container, MobFarmSlots.RESULT_SLOTS.get(slotId).index(), 48 + column * 18, 89 + row * 18));
                ++slotId;
            }
        }
    }

    private void definePlayerInventorySlots() {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.method_7621(new class_1735((class_1263)this.playerInventory, column + row * 9 + 9, 48 + column * 18, 157 + row * 18));
            }
        }
    }

    private void definePlayerHotbarSlots() {
        for (int column = 0; column < 9; ++column) {
            this.method_7621(new class_1735((class_1263)this.playerInventory, column, 48 + column * 18, 215));
        }
    }

    private boolean updateNumberOfOutputSlots() {
        int newNumberOfOutputSlots;
        int numberOfOutputSlots = 6;
        for (class_1735 slot : this.field_7761) {
            if (!(slot instanceof SlotUpgradeSlot) || !slot.method_7681() || slot.method_7677().method_7960()) continue;
            class_1792 class_17922 = slot.method_7677().method_7909();
            if (class_17922 instanceof SmallSlotUpgradeItem) {
                SmallSlotUpgradeItem smallSlotUpgradeItem = (SmallSlotUpgradeItem)class_17922;
                numberOfOutputSlots += smallSlotUpgradeItem.numberOfUpgradeSlots();
                continue;
            }
            class_17922 = slot.method_7677().method_7909();
            if (!(class_17922 instanceof BigSlotUpgradeItem)) continue;
            BigSlotUpgradeItem bigSlotUpgradeItem = (BigSlotUpgradeItem)class_17922;
            numberOfOutputSlots += bigSlotUpgradeItem.numberOfUpgradeSlots();
        }
        int currentNumberOfOutputSlots = this.getMobFarmNumberOfOutputSlots();
        if (currentNumberOfOutputSlots != (newNumberOfOutputSlots = Math.min(Math.max(6, numberOfOutputSlots), 27))) {
            this.setMobFarmNumberOfOutputSlots(newNumberOfOutputSlots);
            this.adjustOutputSlots(newNumberOfOutputSlots);
            return true;
        }
        return false;
    }

    private void adjustOutputSlots(int maxNumberOfOutputSlots) {
        int currentNumberOfOutputSlots = 0;
        for (class_1735 slot : this.field_7761) {
            if (!(slot instanceof OutputSlot)) continue;
            OutputSlot outputSlot = (OutputSlot)slot;
            outputSlot.setActive(currentNumberOfOutputSlots++ < maxNumberOfOutputSlots);
        }
    }

    public void slotUpgradeChanged(SlotUpgradeSlot slot) {
        this.updateNumberOfOutputSlots();
    }

    public boolean method_7597(class_1657 player) {
        return player.method_5805();
    }

    public class_1799 method_7601(class_1657 player, int slotIndex) {
        class_1735 slot = (class_1735)this.field_7761.get(slotIndex);
        if (!slot.method_7681()) {
            return class_1799.field_8037;
        }
        class_1799 itemStack = slot.method_7677();
        class_1799 itemStackCopy = itemStack.method_7972();
        if (slot.field_7871 == this.container) {
            if (!this.method_7616(itemStack, 36, this.field_7761.size(), true)) {
                return class_1799.field_8037;
            }
        } else if (slot.field_7871 == this.playerInventory) {
            for (class_1735 targetSlot : this.field_7761.subList(0, MobFarmSlots.RESULT_SLOTS.size())) {
                if (targetSlot instanceof OutputSlot || targetSlot.method_7681() || !targetSlot.method_7680(itemStack)) continue;
                class_1799 singleItem = itemStack.method_7971(1);
                targetSlot.method_7673(singleItem);
                targetSlot.method_7668();
                break;
            }
        }
        if (itemStack.method_7960()) {
            slot.method_7673(class_1799.field_8037);
        } else {
            slot.method_7668();
        }
        if (itemStack.method_7947() == itemStackCopy.method_7947()) {
            return class_1799.field_8037;
        }
        slot.method_7667(player, itemStack);
        return itemStackCopy;
    }
}

