/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.item;

import de.markusbordihn.easymobfarm.block.entity.MobFarmBlockEntity;
import de.markusbordihn.easymobfarm.config.MobFarmConfig;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmType;
import de.markusbordihn.easymobfarm.network.components.TextComponent;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class MobFarmBlockItem
extends class_1747 {
    public static final String CUSTOM_MODEL_DATA_TAG = "CustomModelData";
    private final String farmName;

    public MobFarmBlockItem(String farmName, class_2248 block) {
        this(farmName, block, new class_1792.class_1793());
    }

    public MobFarmBlockItem(String farmName, class_2248 block, class_1792.class_1793 properties) {
        super(block, properties);
        this.farmName = farmName;
    }

    public static void setTierLevel(class_1799 itemStack, int tierLevel) {
        itemStack.method_7948().method_10569("TierLevel", tierLevel);
        MobFarmBlockItem.setCustomModelData(itemStack);
    }

    private static void setCustomModelData(class_1799 itemStack) {
        int tierLevel;
        class_2487 tag = itemStack.method_7948();
        if (tag.method_10545("TierLevel") && !tag.method_10545(CUSTOM_MODEL_DATA_TAG) && (tierLevel = tag.method_10550("TierLevel")) > 0) {
            tag.method_10569(CUSTOM_MODEL_DATA_TAG, tierLevel);
        }
    }

    public class_2561 method_7864(class_1799 stack) {
        int tierLevel = stack.method_7948().method_10550("TierLevel");
        return TextComponent.getTranslatedBlockText(this.farmName, tierLevel);
    }

    public void method_7843(class_1799 stack, class_1937 level, class_1657 player) {
        super.method_7843(stack, level, player);
        MobFarmBlockItem.setCustomModelData(stack);
    }

    public void method_7851(class_1799 itemStack, class_1937 level, List<class_2561> tooltip, class_1836 flag) {
        class_5250 processingSpeedText;
        class_5250 tierLevelText;
        super.method_7851(itemStack, level, tooltip, flag);
        class_5250 farmDescription = TextComponent.getTranslatedText(this.farmName);
        List lines = class_310.method_1551().field_1772.method_27527().method_27498(farmDescription.getString(), 200, class_2583.field_24360);
        for (class_5348 line : lines) {
            tooltip.add((class_2561)TextComponent.getText(line.getString()).method_27692(class_124.field_1080));
        }
        int tierLevel = itemStack.method_7948().method_10550("TierLevel");
        switch (tierLevel) {
            case 0: {
                class_5250 class_52502 = TextComponent.getTranslatedText("tier_level", tierLevel, class_124.field_1068);
                break;
            }
            case 1: {
                class_5250 class_52502 = TextComponent.getTranslatedText("tier_level", tierLevel, class_124.field_1060);
                break;
            }
            case 2: {
                class_5250 class_52502 = TextComponent.getTranslatedText("tier_level", tierLevel, class_124.field_1054);
                break;
            }
            case 3: {
                class_5250 class_52502 = TextComponent.getTranslatedText("tier_level", tierLevel, class_124.field_1061);
                break;
            }
            default: {
                class_5250 class_52502 = tierLevelText = null;
            }
        }
        if (tierLevelText != null) {
            tooltip.add((class_2561)tierLevelText);
        }
        switch (tierLevel) {
            case 0: {
                class_5250 class_52503 = TextComponent.getTranslatedText("tier_level_processing_speed", MobFarmBlockEntity.getProcessingSpeed(tierLevel), class_124.field_1068);
                break;
            }
            case 1: {
                class_5250 class_52503 = TextComponent.getTranslatedText("tier_level_processing_speed", MobFarmBlockEntity.getProcessingSpeed(tierLevel), class_124.field_1060);
                break;
            }
            case 2: {
                class_5250 class_52503 = TextComponent.getTranslatedText("tier_level_processing_speed", MobFarmBlockEntity.getProcessingSpeed(tierLevel), class_124.field_1054);
                break;
            }
            case 3: {
                class_5250 class_52503 = TextComponent.getTranslatedText("tier_level_processing_speed", MobFarmBlockEntity.getProcessingSpeed(tierLevel), class_124.field_1061);
                break;
            }
            default: {
                class_5250 class_52503 = processingSpeedText = null;
            }
        }
        if (processingSpeedText != null) {
            tooltip.add((class_2561)processingSpeedText);
        }
        if (Objects.equals(this.farmName, MobFarmType.LUCKY_DROP_FARM.getId())) {
            tooltip.add((class_2561)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.lucky_drop_percentage", new Object[]{MobFarmConfig.luckyDropFarmLuckPercentage}).method_27692(class_124.field_1077));
            if (MobFarmConfig.luckyDropFarmLuckPercentage < 100) {
                tooltip.add((class_2561)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.lucky_drop_warn").method_27692(class_124.field_1061));
            }
        }
    }
}

