/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.resources;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureCardDefinition;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureCardDefinitionManager;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_1814;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MobCaptureCardResourceManager
extends class_4309 {
    public static final class_2960 RESOURCE_ID = new class_2960("easy_mob_farm", "mob_capture_card_resource_loader");
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String LOG_PREFIX = "[Mob Capture Card Resource Manager]";
    private static final String SEARCH_PATH = "easy_mob_farm/mob_capture_card";
    private static final String MODEL_TAG = "model";
    private static final String RARITY_TAG = "rarity";
    private static final String REQUIRES_ANIMATION_TICK_TAG = "requires_animation_tick";
    private static final String REQUIRES_KILLED_BY_PLAYER_TAG = "requires_killed_by_player";
    private static final String SCALE_TAG = "scale";
    private static final String COLORS_TAG = "colors";
    private static final String VARIANTS_TAG = "variants";

    public MobCaptureCardResourceManager() {
        super(GSON, SEARCH_PATH);
    }

    protected void apply(Map<class_2960, JsonElement> objectMap, class_3300 resourceManager, class_3695 profiler) {
        log.info("{} Loading definitions ... from {}", (Object)LOG_PREFIX, (Object)SEARCH_PATH);
        MobCaptureCardDefinitionManager.clear();
        objectMap.forEach((location, element) -> {
            try {
                JsonObject json = class_3518.method_15295((JsonElement)element, (String)"mob_capture_card");
                log.debug("{} Parsing definition: {}", (Object)LOG_PREFIX, location);
                class_2960 entity = new class_2960(class_3518.method_15265((JsonObject)json, (String)"entity"));
                class_2960 model = json.has(MODEL_TAG) ? new class_2960(class_3518.method_15265((JsonObject)json, (String)MODEL_TAG)) : null;
                class_1814 rarity = class_1814.valueOf((String)class_3518.method_15253((JsonObject)json, (String)RARITY_TAG, (String)"common").toUpperCase(Locale.ROOT));
                float scale = class_3518.method_15277((JsonObject)json, (String)SCALE_TAG, (float)1.0f);
                boolean requiresKilledByPlayer = class_3518.method_15258((JsonObject)json, (String)REQUIRES_KILLED_BY_PLAYER_TAG, (boolean)false);
                boolean requiresAnimationTick = class_3518.method_15258((JsonObject)json, (String)REQUIRES_ANIMATION_TICK_TAG, (boolean)false);
                Map<String, MobCaptureCardDefinition.Color> colors = this.parseColors(json);
                Map<String, MobCaptureCardDefinition.Variant> variants = this.parseVariants(json);
                MobCaptureCardDefinition definition = new MobCaptureCardDefinition(entity, model, rarity, scale, requiresKilledByPlayer, requiresAnimationTick, variants, colors);
                MobCaptureCardDefinitionManager.addDefinition(entity, definition);
            }
            catch (Exception e) {
                log.error("{} Failed to parse mob_capture_card definition: {} \u2192 {}", (Object)LOG_PREFIX, location, (Object)e.getMessage());
            }
        });
    }

    private Map<String, MobCaptureCardDefinition.Color> parseColors(JsonObject json) {
        HashMap<String, MobCaptureCardDefinition.Color> colors = new HashMap<String, MobCaptureCardDefinition.Color>();
        if (!json.has(COLORS_TAG)) {
            return colors;
        }
        JsonObject colorsJson = class_3518.method_15296((JsonObject)json, (String)COLORS_TAG);
        colorsJson.entrySet().forEach(entry -> {
            String color = (String)entry.getKey();
            class_2960 colorModel = json.has(MODEL_TAG) ? new class_2960(class_3518.method_15265((JsonObject)((JsonElement)entry.getValue()).getAsJsonObject(), (String)MODEL_TAG)) : null;
            colors.put(color, new MobCaptureCardDefinition.Color(colorModel));
        });
        return colors;
    }

    private Map<String, MobCaptureCardDefinition.Variant> parseVariants(JsonObject json) {
        HashMap<String, MobCaptureCardDefinition.Variant> variants = new HashMap<String, MobCaptureCardDefinition.Variant>();
        if (!json.has(VARIANTS_TAG)) {
            return variants;
        }
        JsonObject variantsJson = class_3518.method_15296((JsonObject)json, (String)VARIANTS_TAG);
        variantsJson.entrySet().forEach(entry -> {
            String variant = (String)entry.getKey();
            JsonObject variantObj = ((JsonElement)entry.getValue()).getAsJsonObject();
            class_2960 variantModel = json.has(MODEL_TAG) ? new class_2960(class_3518.method_15253((JsonObject)variantObj, (String)MODEL_TAG, null)) : null;
            HashMap<String, MobCaptureCardDefinition.Color> variantColors = new HashMap<String, MobCaptureCardDefinition.Color>();
            if (variantObj.has(COLORS_TAG)) {
                JsonObject variantColorsJson = class_3518.method_15296((JsonObject)variantObj, (String)COLORS_TAG);
                variantColorsJson.entrySet().forEach(colorEntry -> {
                    String color = (String)colorEntry.getKey();
                    class_2960 colorModel = json.has(MODEL_TAG) ? new class_2960(class_3518.method_15265((JsonObject)((JsonElement)colorEntry.getValue()).getAsJsonObject(), (String)MODEL_TAG)) : null;
                    variantColors.put(color, new MobCaptureCardDefinition.Color(colorModel));
                });
            }
            variants.put(variant, new MobCaptureCardDefinition.Variant(variantModel, variantColors));
        });
        return variants;
    }
}

