/*
 * Decompiled with CFR 0.152.
 */
package com.lankaster.pyrellium.world.tree;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_5141;
import net.minecraft.class_5142;
import net.minecraft.class_5819;
import net.minecraft.class_6017;
import net.minecraft.class_7923;

public class BurningTrunkPlacer
extends class_5141 {
    public static final Codec<BurningTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> BurningTrunkPlacer.method_28904((RecordCodecBuilder.Instance)instance).and(instance.group((App)class_6017.method_35004((int)1, (int)32).fieldOf("fork_height").forGetter(trunkPlacer -> trunkPlacer.forkHeight), (App)class_6017.method_35004((int)1, (int)4).fieldOf("branch_count").forGetter(trunkPlacer -> trunkPlacer.branchCount), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("bend_chance").forGetter(trunkPlacer -> Float.valueOf(trunkPlacer.bendChance)))).apply((Applicative)instance, BurningTrunkPlacer::new));
    public static final class_5142<BurningTrunkPlacer> BURNING_TRUNK_PLACER = (class_5142)class_2378.method_10230((class_2378)class_7923.field_41151, (class_2960)class_2960.method_43902((String)"pyrellium", (String)"burning_trunk_placer"), (Object)new class_5142(CODEC));
    private final class_6017 forkHeight;
    private final class_6017 branchCount;
    private final float bendChance;

    public BurningTrunkPlacer(int baseHeight, int firstRandomHeight, int secondRandomHeight, class_6017 forkHeight, class_6017 branchCount, float bendChance) {
        super(baseHeight, firstRandomHeight, secondRandomHeight);
        this.forkHeight = forkHeight;
        this.branchCount = branchCount;
        this.bendChance = bendChance;
    }

    protected class_5142<?> method_28903() {
        return BURNING_TRUNK_PLACER;
    }

    public List<class_4647.class_5208> method_26991(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, int height, class_2338 startPos, class_4643 config) {
        ArrayList list = Lists.newArrayList();
        class_2338.class_2339 mutable = startPos.method_25503();
        class_2350 direction = class_2350.class_2353.field_11062.method_10183(random);
        int perTreeForkHeight = this.forkHeight.method_35008(random);
        for (int i = 0; i < perTreeForkHeight; ++i) {
            this.method_35375(world, replacer, random, (class_2338)mutable, config);
            if (random.method_43057() < this.bendChance && i >= 2) {
                mutable.method_10098(direction);
            }
            mutable.method_10098(class_2350.field_11036);
        }
        this.generateBranch(world, replacer, random, height, config, list, mutable, perTreeForkHeight, direction);
        if (perTreeForkHeight > height) {
            list.add(new class_4647.class_5208(mutable.method_10062(), 0, false));
        }
        return list;
    }

    private void generateBranch(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, int height, class_4643 config, List<class_4647.class_5208> nodes, class_2338.class_2339 startPos, int yOffset, class_2350 direction) {
        int branches = this.branchCount.method_35008(random);
        class_2338.class_2339 pos = new class_2338.class_2339();
        pos.method_10101((class_2382)startPos);
        direction = direction.method_10153();
        for (int i = 0; i < branches; ++i) {
            direction = branches < 3 ? direction.method_10153() : direction.method_10170();
            for (int l = yOffset; l < height; ++l) {
                if (l < 1) continue;
                this.method_35375(world, replacer, random, (class_2338)pos, config);
                pos.method_10098(direction);
                pos.method_10098(class_2350.field_11036);
            }
            this.method_35375(world, replacer, random, (class_2338)pos, config);
            nodes.add(new class_4647.class_5208(pos.method_10098(class_2350.field_11036).method_10062(), 0, false));
            pos.method_10101((class_2382)startPos);
        }
    }

    public static void registerBurningTrunkPlacer() {
    }
}

