/*
 * Decompiled with CFR 0.152.
 */
package com.cleannrooster.dungeons_iso;

import com.cleannrooster.dungeons_iso.config.Config;
import com.cleannrooster.dungeons_iso.network.Capabilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_265;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_634;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ClientInit
implements ClientModInitializer {
    public static ClientInit instance;
    private static final ArrayList<Consumer<Capabilities>> capabilityListeners;
    public static class_304 toggleBinding;
    public static class_304 isoBinding;
    public static class_304 verticalBinding;
    public static class_304 lockOn;
    public static class_304 clickToMove;
    public static class_304 moveCameraBinding;
    public static class_304 zoomInBinding;
    public static class_304 zoomOutBinding;
    public static class_304 rotateToggle;
    public static class_304 cycleTargetBinding;
    public static class_304 openLootMenu;
    public static class_304 rotateCounterClockwise;
    public static class_304 rotateClockwise;
    public static class_304 interact;
    public static class_304 contextToggleBinding;
    @Nullable
    public static Capabilities capabilities;

    public static boolean serverSupportsCapabilities() {
        return capabilities != null;
    }

    public static boolean isConnectedToServer() {
        class_634 clientPlayNetworkHandler = class_310.method_1551().method_1562();
        return clientPlayNetworkHandler != null && clientPlayNetworkHandler.method_48296().method_10758();
    }

    public static boolean canChangeCapabilities() {
        class_310 client = class_310.method_1551();
        return ClientInit.serverSupportsCapabilities() && client.field_1724 != null && client.field_1724.method_5687(2);
    }

    public static Capabilities getCapabilities() {
        if (!ClientInit.isConnectedToServer()) {
            return Capabilities.all();
        }
        if (!ClientInit.serverSupportsCapabilities()) {
            return Capabilities.none();
        }
        return capabilities;
    }

    public static void submitCapabilities(Capabilities capabilities) {
        ClientPlayNetworking.send((class_8710)capabilities);
    }

    public static void listenCapabilities(Consumer<Capabilities> listener) {
        capabilityListeners.add(listener);
    }

    public static void unlistenCapabilities(Consumer<Capabilities> listener) {
        capabilityListeners.removeIf(l -> l == listener);
    }

    public static void notifyCapabilityListeners() {
        for (int i = capabilityListeners.size() - 1; i >= 0; --i) {
            capabilityListeners.get(i).accept(ClientInit.getCapabilities());
        }
    }

    public void onInitializeClient() {
        instance = this;
        Config.GSON.load();
        toggleBinding = new class_304("dungeons_iso.binds.toggle", class_3675.class_307.field_1668, 293, "dungeons_iso.binds.category");
        KeyBindingHelper.registerKeyBinding((class_304)toggleBinding);
        isoBinding = new class_304("dungeons_iso.binds.iso", class_3675.class_307.field_1668, 268, "dungeons_iso.binds.category");
        KeyBindingHelper.registerKeyBinding((class_304)isoBinding);
        moveCameraBinding = new class_304("dungeons_iso.binds.moveCamera", class_3675.class_307.field_1668, 2, "dungeons_iso.binds.category");
        KeyBindingHelper.registerKeyBinding((class_304)moveCameraBinding);
        lockOn = new class_304("dungeons_iso.binds.lockOn", class_3675.class_307.field_1672, 72, "dungeons_iso.binds.category");
        KeyBindingHelper.registerKeyBinding((class_304)lockOn);
        verticalBinding = new class_304("dungeons_iso.binds.verticalBinding", class_3675.class_307.field_1668, 346, "dungeons_iso.binds.category");
        KeyBindingHelper.registerKeyBinding((class_304)verticalBinding);
        clickToMove = new class_304("dungeons_iso.binds.clickToMove", class_3675.class_307.field_1672, class_3675.field_16237.method_1444(), "dungeons_iso.binds.category");
        KeyBindingHelper.registerKeyBinding((class_304)clickToMove);
        zoomInBinding = new class_304("dungeons_iso.binds.zoomIn", class_3675.class_307.field_1672, 265, "dungeons_iso.binds.category");
        KeyBindingHelper.registerKeyBinding((class_304)zoomInBinding);
        zoomOutBinding = new class_304("dungeons_iso.binds.zoomOut", class_3675.class_307.field_1672, 264, "dungeons_iso.binds.category");
        KeyBindingHelper.registerKeyBinding((class_304)zoomOutBinding);
        rotateToggle = new class_304("dungeons_iso.binds.rotateToggle", class_3675.class_307.field_1668, 261, "dungeons_iso.binds.category");
        KeyBindingHelper.registerKeyBinding((class_304)rotateToggle);
        rotateClockwise = new class_304("dungeons_iso.binds.rotateClockwise", class_3675.class_307.field_1668, 262, "dungeons_iso.binds.category");
        KeyBindingHelper.registerKeyBinding((class_304)rotateClockwise);
        interact = new class_304("dungeons_iso.binds.interact", class_3675.class_307.field_1668, 71, "dungeons_iso.binds.category");
        KeyBindingHelper.registerKeyBinding((class_304)interact);
        rotateCounterClockwise = new class_304("dungeons_iso.binds.rotateCounterClockwise", class_3675.class_307.field_1668, 263, "dungeons_iso.binds.category");
        KeyBindingHelper.registerKeyBinding((class_304)rotateCounterClockwise);
        contextToggleBinding = new class_304("dungeons_iso.binds.dynCameraToggle", class_3675.class_307.field_1668, 269, "dungeons_iso.binds.category");
        KeyBindingHelper.registerKeyBinding((class_304)contextToggleBinding);
        cycleTargetBinding = new class_304("dungeons_iso.binds.cycleTargetBinding", class_3675.class_307.field_1672, 3, "dungeons_iso.binds.category");
        KeyBindingHelper.registerKeyBinding((class_304)cycleTargetBinding);
        openLootMenu = new class_304("dungeons_iso.binds.openLootMenu", class_3675.class_307.field_1668, 90, "dungeons_iso.binds.category");
        KeyBindingHelper.registerKeyBinding((class_304)openLootMenu);
        PayloadTypeRegistry.playC2S().register(Capabilities.ID, Capabilities.CODEC);
        PayloadTypeRegistry.playS2C().register(Capabilities.ID, Capabilities.CODEC);
        ClientPlayNetworking.registerGlobalReceiver(Capabilities.ID, (payload, context) -> {
            capabilities = payload;
            ClientInit.notifyCapabilityListeners();
        });
        ClientPlayConnectionEvents.DISCONNECT.register((networkHandler, minecraftClient) -> {
            capabilities = null;
        });
        ServerLifecycleEvents.SERVER_STARTED.register(minecraftServer -> {
            capabilities = Capabilities.none();
        });
        ServerPlayConnectionEvents.JOIN.register((networkHandler, packetSender, minecraftServer) -> {
            if (networkHandler.field_14140.method_5687(2)) {
                capabilities = Capabilities.load();
            }
            packetSender.sendPacket((class_8710)capabilities);
        });
        ServerPlayNetworking.registerGlobalReceiver(Capabilities.ID, (payload, context) -> {
            if (!context.player().method_5687(2)) {
                return;
            }
            if (!payload.equals(capabilities)) {
                capabilities = payload;
                try {
                    capabilities.save();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                for (class_3222 player : context.server().method_3760().method_14571()) {
                    ServerPlayNetworking.send((class_3222)player, (class_8710)capabilities);
                }
            }
        });
    }

    private static void drawCuboidShapeOutline(class_4587 matrices, class_4588 vertexConsumer, class_265 shape, double offsetX, double offsetY, double offsetZ, float red, float green, float blue, float alpha) {
        class_4587.class_4665 entry = matrices.method_23760();
        shape.method_1104((minX, minY, minZ, maxX, maxY, maxZ) -> {
            float k = (float)(maxX - minX);
            float l = (float)(maxY - minY);
            float m = (float)(maxZ - minZ);
            float n = class_3532.method_15355((float)(k * k + l * l + m * m));
            vertexConsumer.method_56824(entry, (float)(minX + offsetX), (float)(minY + offsetY), (float)(minZ + offsetZ)).method_22915(red, green, blue, alpha).method_60831(entry, k /= n, l /= n, m /= n);
            vertexConsumer.method_56824(entry, (float)(maxX + offsetX), (float)(maxY + offsetY), (float)(maxZ + offsetZ)).method_22915(red, green, blue, alpha).method_60831(entry, k, l, m);
        });
    }

    static {
        capabilityListeners = new ArrayList();
    }
}

