/*
 * Decompiled with CFR 0.152.
 */
package com.esmods.keepersofthestonestwo;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.ARGB;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.levelgen.Heightmap;

public class AutoDodgeEffect {
    private static boolean canTeleportTo(Player player, double x, double y, double z) {
        BlockPos pos1 = new BlockPos((int)x, (int)y, (int)z);
        BlockPos pos2 = new BlockPos((int)x, (int)(y + (double)player.getBbHeight()), (int)z);
        return player.level().getBlockState(pos1).canBeReplaced() && player.level().getBlockState(pos2).canBeReplaced();
    }

    public static void performDodge(Player player) {
        if (player.level().isClientSide) {
            return;
        }
        RandomSource rand = player.getRandom();
        int tries = 10;
        boolean teleported = false;
        for (int i = 0; i < tries; ++i) {
            double x = player.getX() + (rand.nextDouble() - 0.5) * 5.0;
            double z = player.getZ() + (rand.nextDouble() - 0.5) * 5.0;
            double y = player.getY();
            y = player.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, new BlockPos((int)x, (int)y, (int)z)).getY();
            if (!AutoDodgeEffect.canTeleportTo(player, x, y, z)) continue;
            player.teleportTo(x, y, z);
            teleported = true;
            break;
        }
        if (teleported) {
            ServerLevel level = (ServerLevel)player.level();
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ENDERMAN_TELEPORT, player.getSoundSource(), 1.0f, 1.0f);
            DustParticleOptions particle = new DustParticleOptions(ARGB.color((int)0, (int)255, (int)0), 1.0f);
            for (int i = 0; i < 20; ++i) {
                double offsetX = (rand.nextDouble() - 0.5) * 0.5;
                double offsetY = rand.nextDouble() * 2.0;
                double offsetZ = (rand.nextDouble() - 0.5) * 0.5;
                level.sendParticles((ParticleOptions)particle, player.getX() + offsetX, player.getY() + offsetY, player.getZ() + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }
}

