/*
 * Decompiled with CFR 0.152.
 */
package com.esmods.keepersofthestonestwo.client.renderer;

import com.esmods.keepersofthestonestwo.client.model.Modelspirit;
import com.esmods.keepersofthestonestwo.client.model.animations.spiritAnimation;
import com.esmods.keepersofthestonestwo.entity.SpiritEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class SpiritRenderer
extends MobRenderer<SpiritEntity, LivingEntityRenderState, Modelspirit> {
    private SpiritEntity entity = null;

    public SpiritRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelspirit.LAYER_LOCATION)), 0.5f);
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(SpiritEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, state, partialTicks);
        this.entity = entity;
        if (this.model instanceof AnimatedModel) {
            ((AnimatedModel)this.model).setEntity(entity);
        }
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState state) {
        return ResourceLocation.parse((String)"power:textures/entities/spirit.png");
    }

    protected void scale(LivingEntityRenderState state, PoseStack poseStack) {
        poseStack.scale(this.entity.getAgeScale(), this.entity.getAgeScale(), this.entity.getAgeScale());
    }

    private static final class AnimatedModel
    extends Modelspirit {
        private SpiritEntity entity = null;
        private final KeyframeAnimation keyframeAnimation0;

        public AnimatedModel(ModelPart root) {
            super(root);
            this.keyframeAnimation0 = spiritAnimation.idle.bake(root);
        }

        public void setEntity(SpiritEntity entity) {
            this.entity = entity;
        }

        @Override
        public void setupAnim(LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            this.keyframeAnimation0.apply(this.entity.animationState0, state.ageInTicks, 1.0f);
            super.setupAnim(state);
        }
    }
}

