/*
 * Decompiled with CFR 0.152.
 */
package com.esmods.keepersofthestonestwo.client.renderer;

import com.esmods.keepersofthestonestwo.client.model.Modelturret;
import com.esmods.keepersofthestonestwo.client.model.animations.turretAnimation;
import com.esmods.keepersofthestonestwo.entity.TurretEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class TurretRenderer
extends MobRenderer<TurretEntity, LivingEntityRenderState, Modelturret> {
    private TurretEntity entity = null;

    public TurretRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelturret.LAYER_LOCATION)), 0.5f);
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(TurretEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, state, partialTicks);
        this.entity = entity;
        if (this.model instanceof AnimatedModel) {
            ((AnimatedModel)this.model).setEntity(entity);
        }
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState state) {
        return ResourceLocation.parse((String)"power:textures/entities/turret.png");
    }

    protected void scale(LivingEntityRenderState state, PoseStack poseStack) {
        poseStack.scale(this.entity.getAgeScale(), this.entity.getAgeScale(), this.entity.getAgeScale());
    }

    private static final class AnimatedModel
    extends Modelturret {
        private TurretEntity entity = null;
        private final KeyframeAnimation keyframeAnimation0;
        private final KeyframeAnimation keyframeAnimation1;

        public AnimatedModel(ModelPart root) {
            super(root);
            this.keyframeAnimation0 = turretAnimation.walk.bake(root);
            this.keyframeAnimation1 = turretAnimation.idle.bake(root);
        }

        public void setEntity(TurretEntity entity) {
            this.entity = entity;
        }

        @Override
        public void setupAnim(LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            this.keyframeAnimation0.apply(this.entity.animationState0, state.ageInTicks, 1.0f);
            this.keyframeAnimation1.apply(this.entity.animationState1, state.ageInTicks, 1.0f);
            super.setupAnim(state);
        }
    }
}

