/*
 * Decompiled with CFR 0.152.
 */
package com.esmods.keepersofthestonestwo.item;

import com.esmods.keepersofthestonestwo.entity.ShockwaveGunProjectileEntity;
import com.esmods.keepersofthestonestwo.procedures.RemoveForbiddenItemProcedure;
import com.esmods.keepersofthestonestwo.procedures.ShockwaveGunPriVystrielieSnariadomIzPriedmietaProcedure;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class ShockwaveGunItem
extends Item {
    public ShockwaveGunItem(Item.Properties properties) {
        super(properties);
    }

    public ItemUseAnimation getUseAnimation(ItemStack itemstack) {
        return ItemUseAnimation.BOW;
    }

    public int getUseDuration(ItemStack itemstack, LivingEntity livingEntity) {
        return 72000;
    }

    public InteractionResult use(Level world, Player entity, InteractionHand hand) {
        InteractionResult.Fail ar = InteractionResult.FAIL;
        if (entity.getAbilities().instabuild || this.findAmmo(entity) != ItemStack.EMPTY) {
            ar = InteractionResult.SUCCESS;
            entity.startUsingItem(hand);
        }
        return ar;
    }

    public void inventoryTick(ItemStack itemstack, ServerLevel world, Entity entity, @Nullable EquipmentSlot equipmentSlot) {
        super.inventoryTick(itemstack, world, entity, equipmentSlot);
        RemoveForbiddenItemProcedure.execute((LevelAccessor)world, entity, itemstack);
    }

    public boolean releaseUsing(ItemStack itemstack, Level world, LivingEntity entity, int time) {
        if (!world.isClientSide() && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ItemStack stack = this.findAmmo((Player)player);
            if (player.getAbilities().instabuild || stack != ItemStack.EMPTY) {
                ShockwaveGunProjectileEntity projectile = ShockwaveGunProjectileEntity.shoot(world, entity, world.getRandom());
                if (player.getAbilities().instabuild) {
                    projectile.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                } else if (stack.isDamageableItem()) {
                    if (world instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)world;
                        stack.hurtAndBreak(1, serverLevel, player, _stkprov -> {});
                    }
                } else {
                    stack.shrink(1);
                }
                ShockwaveGunPriVystrielieSnariadomIzPriedmietaProcedure.execute((Entity)entity);
            }
        }
        return super.releaseUsing(itemstack, world, entity, time);
    }

    private ItemStack findAmmo(Player player) {
        return new ItemStack((ItemLike)ShockwaveGunProjectileEntity.PROJECTILE_ITEM.getItem());
    }
}

