/*
 * Decompiled with CFR 0.152.
 */
package com.esmods.keepersofthestonestwo.item;

import com.esmods.keepersofthestonestwo.PowerMod;
import com.esmods.keepersofthestonestwo.procedures.GetRechargeInfoProcedure;
import com.esmods.keepersofthestonestwo.procedures.RechargeStoneTickEventProcedure;
import com.esmods.keepersofthestonestwo.procedures.ShockwaveStoneUseProcedure;
import com.esmods.keepersofthestonestwo.procedures.StoneGetRechargeStateProcedure;
import com.mojang.serialization.MapCodec;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.properties.numeric.RangeSelectItemModelProperty;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class ShockwaveStoneItem
extends Item {
    public ShockwaveStoneItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    public float getDestroySpeed(ItemStack itemstack, BlockState state) {
        return 0.0f;
    }

    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> componentConsumer, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, tooltipDisplay, componentConsumer, flag);
        Player entity = itemstack.getEntityRepresentation() != null ? itemstack.getEntityRepresentation() : PowerMod.clientPlayer();
        String hoverText = GetRechargeInfoProcedure.execute(itemstack);
        if (hoverText != null) {
            for (String line : hoverText.split("\n")) {
                componentConsumer.accept((Component)Component.literal((String)line));
            }
        }
    }

    public InteractionResult use(Level world, Player entity, InteractionHand hand) {
        InteractionResult ar = super.use(world, entity, hand);
        ShockwaveStoneUseProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), (Entity)entity, entity.getItemInHand(hand));
        return ar;
    }

    public void inventoryTick(ItemStack itemstack, ServerLevel world, Entity entity, @Nullable EquipmentSlot equipmentSlot) {
        super.inventoryTick(itemstack, world, entity, equipmentSlot);
        RechargeStoneTickEventProcedure.execute(itemstack);
    }

    public record RechageProperty() implements RangeSelectItemModelProperty
    {
        public static final MapCodec<RechageProperty> MAP_CODEC = MapCodec.unit((Object)new RechageProperty());

        public float get(ItemStack itemStackToRender, @Nullable ClientLevel clientWorld, @Nullable LivingEntity entity, int seed) {
            return (float)StoneGetRechargeStateProcedure.execute(itemStackToRender);
        }

        public MapCodec<RechageProperty> type() {
            return MAP_CODEC;
        }
    }
}

