/*
 * Decompiled with CFR 0.152.
 */
package com.esmods.keepersofthestonestwo.network;

import com.esmods.keepersofthestonestwo.PowerMod;
import com.esmods.keepersofthestonestwo.procedures.HeatElementGetProcedure;
import com.esmods.keepersofthestonestwo.procedures.KBtoPart4Procedure;
import com.esmods.keepersofthestonestwo.procedures.ShockwaveElementGetProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber
public record KeepersBoxGUIPart5ButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<KeepersBoxGUIPart5ButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"power", (String)"keepers_box_gui_part_5_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, KeepersBoxGUIPart5ButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new KeepersBoxGUIPart5ButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<KeepersBoxGUIPart5ButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(KeepersBoxGUIPart5ButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> KeepersBoxGUIPart5ButtonMessage.handleButtonAction(context.player(), message.buttonID, message.x, message.y, message.z)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            KBtoPart4Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 12) {
            HeatElementGetProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 13) {
            ShockwaveElementGetProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        PowerMod.addNetworkMessage(TYPE, STREAM_CODEC, KeepersBoxGUIPart5ButtonMessage::handleData);
    }
}

