/*
 * Decompiled with CFR 0.152.
 */
package com.esmods.keepersofthestonestwo.network;

import com.esmods.keepersofthestonestwo.PowerMod;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.ValueIOSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber
public class PowerModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"power");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        PowerMod.addNetworkMessage(SavedDataSyncMessage.TYPE, SavedDataSyncMessage.STREAM_CODEC, SavedDataSyncMessage::handleData);
        PowerMod.addNetworkMessage(PlayerVariablesSyncMessage.TYPE, PlayerVariablesSyncMessage.STREAM_CODEC, PlayerVariablesSyncMessage::handleData);
    }

    @SubscribeEvent
    public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PlayerVariablesSyncMessage((PlayerVariables)player2.getData(PLAYER_VARIABLES)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PlayerVariablesSyncMessage((PlayerVariables)player2.getData(PLAYER_VARIABLES)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PlayerVariablesSyncMessage((PlayerVariables)player2.getData(PLAYER_VARIABLES)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onPlayerTickUpdateSyncPlayerVariables(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (((PlayerVariables)player2.getData(PowerModVariables.PLAYER_VARIABLES))._syncDirty) {
                PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new PlayerVariablesSyncMessage((PlayerVariables)player2.getData(PLAYER_VARIABLES)), (CustomPacketPayload[])new CustomPacketPayload[0]);
                ((PlayerVariables)player2.getData(PowerModVariables.PLAYER_VARIABLES))._syncDirty = false;
            }
        }
    }

    @SubscribeEvent
    public static void clonePlayer(PlayerEvent.Clone event) {
        PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
        PlayerVariables clone = new PlayerVariables();
        clone.ability = original.ability;
        clone.element_name_first = original.element_name_first;
        clone.element_name_second = original.element_name_second;
        clone.element_name_third = original.element_name_third;
        clone.fake_element_name_first = original.fake_element_name_first;
        clone.fake_element_name_second = original.fake_element_name_second;
        clone.fake_element_name_third = original.fake_element_name_third;
        clone.max_power = original.max_power;
        clone.recharge_timer = original.recharge_timer;
        clone.master_effect_duration = original.master_effect_duration;
        clone.selected = original.selected;
        clone.active_battery = original.active_battery;
        clone.debug = original.debug;
        clone.helmet = original.helmet;
        clone.chestplate = original.chestplate;
        clone.leggings = original.leggings;
        clone.boots = original.boots;
        clone.unlock_keepers_box = original.unlock_keepers_box;
        clone.level = original.level;
        clone.level_exp = original.level_exp;
        clone.base_damage_by_lvl = original.base_damage_by_lvl;
        clone.max_level_exp = original.max_level_exp;
        clone.resistance_char = original.resistance_char;
        clone.speed_char = original.speed_char;
        clone.haste_char = original.haste_char;
        clone.jump_char = original.jump_char;
        clone.rank = original.rank;
        clone.mind_used = original.mind_used;
        clone.blue_rune_slot = original.blue_rune_slot;
        clone.red_rune_slot = original.red_rune_slot;
        clone.green_rune_slot = original.green_rune_slot;
        if (!event.isWasDeath()) {
            clone.teleporting_effect = original.teleporting_effect;
            clone.abilities_timer = original.abilities_timer;
            clone.fake_element_name_first_timer = original.fake_element_name_first_timer;
            clone.fake_element_name_second_timer = original.fake_element_name_second_timer;
            clone.fake_element_name_third_timer = original.fake_element_name_third_timer;
            clone.power = original.power;
            clone.powerTimer = original.powerTimer;
            clone.mergers = original.mergers;
            clone.power_recovery_multiplier = original.power_recovery_multiplier;
            clone.active_power = original.active_power;
            clone.ability_block = original.ability_block;
            clone.use_ability_key_var = original.use_ability_key_var;
            clone.detransf_key_var = original.detransf_key_var;
            clone.wheel_open_key_var = original.wheel_open_key_var;
            clone.second_wheel_open_var = original.second_wheel_open_var;
            clone.third_wheel_open_var = original.third_wheel_open_var;
            clone.first_fake_wheel_open_var = original.first_fake_wheel_open_var;
            clone.second_fake_wheel_open_var = original.second_fake_wheel_open_var;
            clone.third_fake_wheel_open_var = original.third_fake_wheel_open_var;
            clone.ability_using = original.ability_using;
            clone.power_recorded = original.power_recorded;
            clone.detransform_anim_trigger = original.detransform_anim_trigger;
            clone.transfered_power = original.transfered_power;
            clone.master_effect_end = original.master_effect_end;
            clone.master_effect_start = original.master_effect_start;
            clone.level_up_status = original.level_up_status;
            clone.mind_player_owner = original.mind_player_owner;
            clone.rune_ovelay_display = original.rune_ovelay_display;
        }
        event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().level());
            WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
            if (mapdata != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(0, mapdata), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (worlddata != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
            if (worlddata != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @SubscribeEvent
    public static void onWorldTick(LevelTickEvent.Post event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            WorldVariables worldVariables = WorldVariables.get((LevelAccessor)level2);
            if (worldVariables._syncDirty) {
                PacketDistributor.sendToPlayersInDimension((ServerLevel)level2, (CustomPacketPayload)new SavedDataSyncMessage(1, worldVariables), (CustomPacketPayload[])new CustomPacketPayload[0]);
                worldVariables._syncDirty = false;
            }
            MapVariables mapVariables = MapVariables.get((LevelAccessor)level2);
            if (mapVariables._syncDirty) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SavedDataSyncMessage(0, mapVariables), (CustomPacketPayload[])new CustomPacketPayload[0]);
                mapVariables._syncDirty = false;
            }
        }
    }

    public record SavedDataSyncMessage(int dataType, SavedData data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SavedDataSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"power", (String)"saved_data_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, SavedDataSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            buffer.writeInt(message.dataType);
            SavedData patt0$temp = message.data;
            if (patt0$temp instanceof MapVariables) {
                MapVariables mapVariables = (MapVariables)patt0$temp;
                buffer.writeNbt((Tag)mapVariables.save(new CompoundTag(), (HolderLookup.Provider)buffer.registryAccess()));
            } else {
                SavedData patt1$temp = message.data;
                if (patt1$temp instanceof WorldVariables) {
                    WorldVariables worldVariables = (WorldVariables)patt1$temp;
                    buffer.writeNbt((Tag)worldVariables.save(new CompoundTag(), (HolderLookup.Provider)buffer.registryAccess()));
                }
            }
        }, buffer -> {
            int dataType = buffer.readInt();
            CompoundTag nbt = buffer.readNbt();
            SavedData data = null;
            if (nbt != null) {
                SavedData savedData = data = dataType == 0 ? new MapVariables() : new WorldVariables();
                if (data instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)data;
                    mapVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                } else if (data instanceof WorldVariables) {
                    WorldVariables worldVariables = (WorldVariables)data;
                    worldVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                }
            }
            return new SavedDataSyncMessage(dataType, data);
        });

        public CustomPacketPayload.Type<SavedDataSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(SavedDataSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> {
                    if (message.dataType == 0) {
                        MapVariables.clientSide.read(((MapVariables)message.data).save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    } else {
                        WorldVariables.clientSide.read(((WorldVariables)message.data).save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    }
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"power", (String)"player_variables_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            TagValueOutput output = TagValueOutput.createWithoutContext((ProblemReporter)ProblemReporter.DISCARDING);
            message.data.serialize((ValueOutput)output);
            buffer.writeNbt((Tag)output.buildResult());
        }, buffer -> {
            PlayerVariablesSyncMessage message = new PlayerVariablesSyncMessage(new PlayerVariables());
            message.data.deserialize(TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)buffer.registryAccess(), (CompoundTag)buffer.readNbt()));
            return message;
        });

        public CustomPacketPayload.Type<PlayerVariablesSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerVariablesSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> {
                    TagValueOutput output = TagValueOutput.createWithContext((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)context.player().registryAccess());
                    message.data.serialize((ValueOutput)output);
                    ((PlayerVariables)context.player().getData(PLAYER_VARIABLES)).deserialize(TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)context.player().registryAccess(), (CompoundTag)output.buildResult()));
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements ValueIOSerializable {
        boolean _syncDirty = false;
        public String ability = "0";
        public String element_name_first = "0";
        public String element_name_second = "0";
        public String element_name_third = "0";
        public double teleporting_effect = 0.0;
        public String fake_element_name_first = "0";
        public String fake_element_name_second = "0";
        public String fake_element_name_third = "0";
        public double abilities_timer = 0.0;
        public double fake_element_name_first_timer = 0.0;
        public double fake_element_name_second_timer = 0.0;
        public double fake_element_name_third_timer = 0.0;
        public double power = 0.0;
        public double powerTimer = 0.0;
        public double mergers = 0.0;
        public double power_recovery_multiplier = 1.0;
        public double max_power = 100.0;
        public double recharge_timer = 300.0;
        public double master_effect_duration = 600.0;
        public boolean active_power = false;
        public boolean selected = false;
        public boolean active_battery = false;
        public boolean ability_block = false;
        public boolean use_ability_key_var = false;
        public boolean detransf_key_var = false;
        public boolean wheel_open_key_var = false;
        public boolean second_wheel_open_var = false;
        public boolean third_wheel_open_var = false;
        public boolean first_fake_wheel_open_var = false;
        public boolean second_fake_wheel_open_var = false;
        public boolean third_fake_wheel_open_var = false;
        public boolean ability_using = false;
        public boolean power_recorded = false;
        public boolean debug = false;
        public boolean detransform_anim_trigger = false;
        public ItemStack helmet = ItemStack.EMPTY;
        public ItemStack chestplate = ItemStack.EMPTY;
        public ItemStack leggings = ItemStack.EMPTY;
        public ItemStack boots = ItemStack.EMPTY;
        public boolean unlock_keepers_box = false;
        public boolean transfered_power = false;
        public boolean master_effect_end = false;
        public boolean master_effect_start = false;
        public double level = 1.0;
        public double level_exp = 0.0;
        public double base_damage_by_lvl = 6.0;
        public double max_level_exp = 100.0;
        public double resistance_char = 0.0;
        public double speed_char = 1.0;
        public double haste_char = -1.0;
        public double jump_char = 1.0;
        public boolean level_up_status = false;
        public String rank = "D";
        public String mind_player_owner = "\"\"";
        public boolean mind_used = false;
        public ItemStack blue_rune_slot = ItemStack.EMPTY;
        public ItemStack red_rune_slot = ItemStack.EMPTY;
        public ItemStack green_rune_slot = ItemStack.EMPTY;
        public double rune_ovelay_display = 0.0;

        public void serialize(ValueOutput output) {
            output.putString("ability", this.ability);
            output.putString("element_name_first", this.element_name_first);
            output.putString("element_name_second", this.element_name_second);
            output.putString("element_name_third", this.element_name_third);
            output.putDouble("teleporting_effect", this.teleporting_effect);
            output.putString("fake_element_name_first", this.fake_element_name_first);
            output.putString("fake_element_name_second", this.fake_element_name_second);
            output.putString("fake_element_name_third", this.fake_element_name_third);
            output.putDouble("abilities_timer", this.abilities_timer);
            output.putDouble("fake_element_name_first_timer", this.fake_element_name_first_timer);
            output.putDouble("fake_element_name_second_timer", this.fake_element_name_second_timer);
            output.putDouble("fake_element_name_third_timer", this.fake_element_name_third_timer);
            output.putDouble("power", this.power);
            output.putDouble("powerTimer", this.powerTimer);
            output.putDouble("mergers", this.mergers);
            output.putDouble("power_recovery_multiplier", this.power_recovery_multiplier);
            output.putDouble("max_power", this.max_power);
            output.putDouble("recharge_timer", this.recharge_timer);
            output.putDouble("master_effect_duration", this.master_effect_duration);
            output.putBoolean("active_power", this.active_power);
            output.putBoolean("selected", this.selected);
            output.putBoolean("active_battery", this.active_battery);
            output.putBoolean("ability_block", this.ability_block);
            output.putBoolean("use_ability_key_var", this.use_ability_key_var);
            output.putBoolean("detransf_key_var", this.detransf_key_var);
            output.putBoolean("wheel_open_key_var", this.wheel_open_key_var);
            output.putBoolean("second_wheel_open_var", this.second_wheel_open_var);
            output.putBoolean("third_wheel_open_var", this.third_wheel_open_var);
            output.putBoolean("first_fake_wheel_open_var", this.first_fake_wheel_open_var);
            output.putBoolean("second_fake_wheel_open_var", this.second_fake_wheel_open_var);
            output.putBoolean("third_fake_wheel_open_var", this.third_fake_wheel_open_var);
            output.putBoolean("ability_using", this.ability_using);
            output.putBoolean("power_recorded", this.power_recorded);
            output.putBoolean("debug", this.debug);
            output.putBoolean("detransform_anim_trigger", this.detransform_anim_trigger);
            output.store("helmet", ItemStack.OPTIONAL_CODEC, (Object)this.helmet);
            output.store("chestplate", ItemStack.OPTIONAL_CODEC, (Object)this.chestplate);
            output.store("leggings", ItemStack.OPTIONAL_CODEC, (Object)this.leggings);
            output.store("boots", ItemStack.OPTIONAL_CODEC, (Object)this.boots);
            output.putBoolean("unlock_keepers_box", this.unlock_keepers_box);
            output.putBoolean("transfered_power", this.transfered_power);
            output.putBoolean("master_effect_end", this.master_effect_end);
            output.putBoolean("master_effect_start", this.master_effect_start);
            output.putDouble("level", this.level);
            output.putDouble("level_exp", this.level_exp);
            output.putDouble("base_damage_by_lvl", this.base_damage_by_lvl);
            output.putDouble("max_level_exp", this.max_level_exp);
            output.putDouble("resistance_char", this.resistance_char);
            output.putDouble("speed_char", this.speed_char);
            output.putDouble("haste_char", this.haste_char);
            output.putDouble("jump_char", this.jump_char);
            output.putBoolean("level_up_status", this.level_up_status);
            output.putString("rank", this.rank);
            output.putString("mind_player_owner", this.mind_player_owner);
            output.putBoolean("mind_used", this.mind_used);
            output.store("blue_rune_slot", ItemStack.OPTIONAL_CODEC, (Object)this.blue_rune_slot);
            output.store("red_rune_slot", ItemStack.OPTIONAL_CODEC, (Object)this.red_rune_slot);
            output.store("green_rune_slot", ItemStack.OPTIONAL_CODEC, (Object)this.green_rune_slot);
            output.putDouble("rune_ovelay_display", this.rune_ovelay_display);
        }

        public void deserialize(ValueInput input) {
            this.ability = input.getStringOr("ability", "");
            this.element_name_first = input.getStringOr("element_name_first", "");
            this.element_name_second = input.getStringOr("element_name_second", "");
            this.element_name_third = input.getStringOr("element_name_third", "");
            this.teleporting_effect = input.getDoubleOr("teleporting_effect", 0.0);
            this.fake_element_name_first = input.getStringOr("fake_element_name_first", "");
            this.fake_element_name_second = input.getStringOr("fake_element_name_second", "");
            this.fake_element_name_third = input.getStringOr("fake_element_name_third", "");
            this.abilities_timer = input.getDoubleOr("abilities_timer", 0.0);
            this.fake_element_name_first_timer = input.getDoubleOr("fake_element_name_first_timer", 0.0);
            this.fake_element_name_second_timer = input.getDoubleOr("fake_element_name_second_timer", 0.0);
            this.fake_element_name_third_timer = input.getDoubleOr("fake_element_name_third_timer", 0.0);
            this.power = input.getDoubleOr("power", 0.0);
            this.powerTimer = input.getDoubleOr("powerTimer", 0.0);
            this.mergers = input.getDoubleOr("mergers", 0.0);
            this.power_recovery_multiplier = input.getDoubleOr("power_recovery_multiplier", 0.0);
            this.max_power = input.getDoubleOr("max_power", 0.0);
            this.recharge_timer = input.getDoubleOr("recharge_timer", 0.0);
            this.master_effect_duration = input.getDoubleOr("master_effect_duration", 0.0);
            this.active_power = input.getBooleanOr("active_power", false);
            this.selected = input.getBooleanOr("selected", false);
            this.active_battery = input.getBooleanOr("active_battery", false);
            this.ability_block = input.getBooleanOr("ability_block", false);
            this.use_ability_key_var = input.getBooleanOr("use_ability_key_var", false);
            this.detransf_key_var = input.getBooleanOr("detransf_key_var", false);
            this.wheel_open_key_var = input.getBooleanOr("wheel_open_key_var", false);
            this.second_wheel_open_var = input.getBooleanOr("second_wheel_open_var", false);
            this.third_wheel_open_var = input.getBooleanOr("third_wheel_open_var", false);
            this.first_fake_wheel_open_var = input.getBooleanOr("first_fake_wheel_open_var", false);
            this.second_fake_wheel_open_var = input.getBooleanOr("second_fake_wheel_open_var", false);
            this.third_fake_wheel_open_var = input.getBooleanOr("third_fake_wheel_open_var", false);
            this.ability_using = input.getBooleanOr("ability_using", false);
            this.power_recorded = input.getBooleanOr("power_recorded", false);
            this.debug = input.getBooleanOr("debug", false);
            this.detransform_anim_trigger = input.getBooleanOr("detransform_anim_trigger", false);
            this.helmet = input.read("helmet", ItemStack.OPTIONAL_CODEC).orElse(ItemStack.EMPTY);
            this.chestplate = input.read("chestplate", ItemStack.OPTIONAL_CODEC).orElse(ItemStack.EMPTY);
            this.leggings = input.read("leggings", ItemStack.OPTIONAL_CODEC).orElse(ItemStack.EMPTY);
            this.boots = input.read("boots", ItemStack.OPTIONAL_CODEC).orElse(ItemStack.EMPTY);
            this.unlock_keepers_box = input.getBooleanOr("unlock_keepers_box", false);
            this.transfered_power = input.getBooleanOr("transfered_power", false);
            this.master_effect_end = input.getBooleanOr("master_effect_end", false);
            this.master_effect_start = input.getBooleanOr("master_effect_start", false);
            this.level = input.getDoubleOr("level", 0.0);
            this.level_exp = input.getDoubleOr("level_exp", 0.0);
            this.base_damage_by_lvl = input.getDoubleOr("base_damage_by_lvl", 0.0);
            this.max_level_exp = input.getDoubleOr("max_level_exp", 0.0);
            this.resistance_char = input.getDoubleOr("resistance_char", 0.0);
            this.speed_char = input.getDoubleOr("speed_char", 0.0);
            this.haste_char = input.getDoubleOr("haste_char", 0.0);
            this.jump_char = input.getDoubleOr("jump_char", 0.0);
            this.level_up_status = input.getBooleanOr("level_up_status", false);
            this.rank = input.getStringOr("rank", "");
            this.mind_player_owner = input.getStringOr("mind_player_owner", "");
            this.mind_used = input.getBooleanOr("mind_used", false);
            this.blue_rune_slot = input.read("blue_rune_slot", ItemStack.OPTIONAL_CODEC).orElse(ItemStack.EMPTY);
            this.red_rune_slot = input.read("red_rune_slot", ItemStack.OPTIONAL_CODEC).orElse(ItemStack.EMPTY);
            this.green_rune_slot = input.read("green_rune_slot", ItemStack.OPTIONAL_CODEC).orElse(ItemStack.EMPTY);
            this.rune_ovelay_display = input.getDoubleOr("rune_ovelay_display", 0.0);
        }

        public void markSyncDirty() {
            this._syncDirty = true;
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final SavedDataType<MapVariables> TYPE = new SavedDataType("power_mapvars", ctx -> new MapVariables(), ctx -> CompoundTag.CODEC.xmap(tag -> {
            MapVariables instance = new MapVariables();
            instance.read((CompoundTag)tag, (HolderLookup.Provider)ctx.levelOrThrow().registryAccess());
            return instance;
        }, instance -> instance.save(new CompoundTag(), (HolderLookup.Provider)ctx.levelOrThrow().registryAccess())));
        boolean _syncDirty = false;
        public double opX = 0.0;
        public double opY = 0.0;
        public double opZ = 0.0;
        public double bpX = 0.0;
        public double bpY = 0.0;
        public double bpZ = 0.0;
        public boolean fire_stone = false;
        public boolean air_stone = false;
        public boolean earth_stone = false;
        public boolean water_stone = false;
        public boolean ether_stone = false;
        public boolean ice_stone = false;
        public boolean lightning_stone = false;
        public boolean sound_stone = false;
        public boolean crystal_stone = false;
        public boolean lava_stone = false;
        public boolean rain_stone = false;
        public boolean tornado_stone = false;
        public boolean ocean_stone = false;
        public boolean plants_stone = false;
        public boolean animals_stone = false;
        public boolean metal_stone = false;
        public boolean light_stone = false;
        public boolean shadow_stone = false;
        public boolean vacuum_stone = false;
        public boolean energy_stone = false;
        public boolean sun_stone = false;
        public boolean moon_stone = false;
        public boolean space_stone = false;
        public boolean time_stone = false;
        public boolean blood_stone = false;
        public boolean technology_stone = false;
        public boolean teleportation_stone = false;
        public boolean explosion_stone = false;
        public boolean amber_stone = false;
        public boolean creation_stone = false;
        public boolean destruction_stone = false;
        public boolean mist_stone = false;
        public boolean sand_stone = false;
        public boolean speed_stone = false;
        public boolean poison_stone = false;
        public boolean magnet_stone = false;
        public boolean mushrooms_stone = false;
        public boolean mercury_stone = false;
        public boolean music_stone = false;
        public boolean plague_stone = false;
        public boolean blue_flame_stone = false;
        public boolean gravity_stone = false;
        public boolean smoke_stone = false;
        public boolean spirit_stone = false;
        public boolean form_stone = false;
        public boolean mind_stone = false;
        public boolean golden_dust_stone = false;
        public boolean darkness_stone = false;
        public boolean blue_portal_placed = false;
        public boolean orange_portal_placed = false;
        public double cpapi_ver = 21.0;
        public boolean heat_stone = false;
        public boolean shockwave_stone = false;
        static MapVariables clientSide = new MapVariables();

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.opX = nbt.getDoubleOr("opX", 0.0);
            this.opY = nbt.getDoubleOr("opY", 0.0);
            this.opZ = nbt.getDoubleOr("opZ", 0.0);
            this.bpX = nbt.getDoubleOr("bpX", 0.0);
            this.bpY = nbt.getDoubleOr("bpY", 0.0);
            this.bpZ = nbt.getDoubleOr("bpZ", 0.0);
            this.fire_stone = nbt.getBooleanOr("fire_stone", false);
            this.air_stone = nbt.getBooleanOr("air_stone", false);
            this.earth_stone = nbt.getBooleanOr("earth_stone", false);
            this.water_stone = nbt.getBooleanOr("water_stone", false);
            this.ether_stone = nbt.getBooleanOr("ether_stone", false);
            this.ice_stone = nbt.getBooleanOr("ice_stone", false);
            this.lightning_stone = nbt.getBooleanOr("lightning_stone", false);
            this.sound_stone = nbt.getBooleanOr("sound_stone", false);
            this.crystal_stone = nbt.getBooleanOr("crystal_stone", false);
            this.lava_stone = nbt.getBooleanOr("lava_stone", false);
            this.rain_stone = nbt.getBooleanOr("rain_stone", false);
            this.tornado_stone = nbt.getBooleanOr("tornado_stone", false);
            this.ocean_stone = nbt.getBooleanOr("ocean_stone", false);
            this.plants_stone = nbt.getBooleanOr("plants_stone", false);
            this.animals_stone = nbt.getBooleanOr("animals_stone", false);
            this.metal_stone = nbt.getBooleanOr("metal_stone", false);
            this.light_stone = nbt.getBooleanOr("light_stone", false);
            this.shadow_stone = nbt.getBooleanOr("shadow_stone", false);
            this.vacuum_stone = nbt.getBooleanOr("vacuum_stone", false);
            this.energy_stone = nbt.getBooleanOr("energy_stone", false);
            this.sun_stone = nbt.getBooleanOr("sun_stone", false);
            this.moon_stone = nbt.getBooleanOr("moon_stone", false);
            this.space_stone = nbt.getBooleanOr("space_stone", false);
            this.time_stone = nbt.getBooleanOr("time_stone", false);
            this.blood_stone = nbt.getBooleanOr("blood_stone", false);
            this.technology_stone = nbt.getBooleanOr("technology_stone", false);
            this.teleportation_stone = nbt.getBooleanOr("teleportation_stone", false);
            this.explosion_stone = nbt.getBooleanOr("explosion_stone", false);
            this.amber_stone = nbt.getBooleanOr("amber_stone", false);
            this.creation_stone = nbt.getBooleanOr("creation_stone", false);
            this.destruction_stone = nbt.getBooleanOr("destruction_stone", false);
            this.mist_stone = nbt.getBooleanOr("mist_stone", false);
            this.sand_stone = nbt.getBooleanOr("sand_stone", false);
            this.speed_stone = nbt.getBooleanOr("speed_stone", false);
            this.poison_stone = nbt.getBooleanOr("poison_stone", false);
            this.magnet_stone = nbt.getBooleanOr("magnet_stone", false);
            this.mushrooms_stone = nbt.getBooleanOr("mushrooms_stone", false);
            this.mercury_stone = nbt.getBooleanOr("mercury_stone", false);
            this.music_stone = nbt.getBooleanOr("music_stone", false);
            this.plague_stone = nbt.getBooleanOr("plague_stone", false);
            this.blue_flame_stone = nbt.getBooleanOr("blue_flame_stone", false);
            this.gravity_stone = nbt.getBooleanOr("gravity_stone", false);
            this.smoke_stone = nbt.getBooleanOr("smoke_stone", false);
            this.spirit_stone = nbt.getBooleanOr("spirit_stone", false);
            this.form_stone = nbt.getBooleanOr("form_stone", false);
            this.mind_stone = nbt.getBooleanOr("mind_stone", false);
            this.golden_dust_stone = nbt.getBooleanOr("golden_dust_stone", false);
            this.darkness_stone = nbt.getBooleanOr("darkness_stone", false);
            this.blue_portal_placed = nbt.getBooleanOr("blue_portal_placed", false);
            this.orange_portal_placed = nbt.getBooleanOr("orange_portal_placed", false);
            this.cpapi_ver = nbt.getDoubleOr("cpapi_ver", 0.0);
            this.heat_stone = nbt.getBooleanOr("heat_stone", false);
            this.shockwave_stone = nbt.getBooleanOr("shockwave_stone", false);
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putDouble("opX", this.opX);
            nbt.putDouble("opY", this.opY);
            nbt.putDouble("opZ", this.opZ);
            nbt.putDouble("bpX", this.bpX);
            nbt.putDouble("bpY", this.bpY);
            nbt.putDouble("bpZ", this.bpZ);
            nbt.putBoolean("fire_stone", this.fire_stone);
            nbt.putBoolean("air_stone", this.air_stone);
            nbt.putBoolean("earth_stone", this.earth_stone);
            nbt.putBoolean("water_stone", this.water_stone);
            nbt.putBoolean("ether_stone", this.ether_stone);
            nbt.putBoolean("ice_stone", this.ice_stone);
            nbt.putBoolean("lightning_stone", this.lightning_stone);
            nbt.putBoolean("sound_stone", this.sound_stone);
            nbt.putBoolean("crystal_stone", this.crystal_stone);
            nbt.putBoolean("lava_stone", this.lava_stone);
            nbt.putBoolean("rain_stone", this.rain_stone);
            nbt.putBoolean("tornado_stone", this.tornado_stone);
            nbt.putBoolean("ocean_stone", this.ocean_stone);
            nbt.putBoolean("plants_stone", this.plants_stone);
            nbt.putBoolean("animals_stone", this.animals_stone);
            nbt.putBoolean("metal_stone", this.metal_stone);
            nbt.putBoolean("light_stone", this.light_stone);
            nbt.putBoolean("shadow_stone", this.shadow_stone);
            nbt.putBoolean("vacuum_stone", this.vacuum_stone);
            nbt.putBoolean("energy_stone", this.energy_stone);
            nbt.putBoolean("sun_stone", this.sun_stone);
            nbt.putBoolean("moon_stone", this.moon_stone);
            nbt.putBoolean("space_stone", this.space_stone);
            nbt.putBoolean("time_stone", this.time_stone);
            nbt.putBoolean("blood_stone", this.blood_stone);
            nbt.putBoolean("technology_stone", this.technology_stone);
            nbt.putBoolean("teleportation_stone", this.teleportation_stone);
            nbt.putBoolean("explosion_stone", this.explosion_stone);
            nbt.putBoolean("amber_stone", this.amber_stone);
            nbt.putBoolean("creation_stone", this.creation_stone);
            nbt.putBoolean("destruction_stone", this.destruction_stone);
            nbt.putBoolean("mist_stone", this.mist_stone);
            nbt.putBoolean("sand_stone", this.sand_stone);
            nbt.putBoolean("speed_stone", this.speed_stone);
            nbt.putBoolean("poison_stone", this.poison_stone);
            nbt.putBoolean("magnet_stone", this.magnet_stone);
            nbt.putBoolean("mushrooms_stone", this.mushrooms_stone);
            nbt.putBoolean("mercury_stone", this.mercury_stone);
            nbt.putBoolean("music_stone", this.music_stone);
            nbt.putBoolean("plague_stone", this.plague_stone);
            nbt.putBoolean("blue_flame_stone", this.blue_flame_stone);
            nbt.putBoolean("gravity_stone", this.gravity_stone);
            nbt.putBoolean("smoke_stone", this.smoke_stone);
            nbt.putBoolean("spirit_stone", this.spirit_stone);
            nbt.putBoolean("form_stone", this.form_stone);
            nbt.putBoolean("mind_stone", this.mind_stone);
            nbt.putBoolean("golden_dust_stone", this.golden_dust_stone);
            nbt.putBoolean("darkness_stone", this.darkness_stone);
            nbt.putBoolean("blue_portal_placed", this.blue_portal_placed);
            nbt.putBoolean("orange_portal_placed", this.orange_portal_placed);
            nbt.putDouble("cpapi_ver", this.cpapi_ver);
            nbt.putBoolean("heat_stone", this.heat_stone);
            nbt.putBoolean("shockwave_stone", this.shockwave_stone);
            return nbt;
        }

        public void markSyncDirty() {
            this.setDirty();
            this._syncDirty = true;
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAccessor = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAccessor.getLevel().getServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(TYPE);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final SavedDataType<WorldVariables> TYPE = new SavedDataType("power_worldvars", ctx -> new WorldVariables(), ctx -> CompoundTag.CODEC.xmap(tag -> {
            WorldVariables instance = new WorldVariables();
            instance.read((CompoundTag)tag, (HolderLookup.Provider)ctx.levelOrThrow().registryAccess());
            return instance;
        }, instance -> instance.save(new CompoundTag(), (HolderLookup.Provider)ctx.levelOrThrow().registryAccess())));
        boolean _syncDirty = false;
        public double entity_rotation = 0.0;
        static WorldVariables clientSide = new WorldVariables();

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.entity_rotation = nbt.getDoubleOr("entity_rotation", 0.0);
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putDouble("entity_rotation", this.entity_rotation);
            return nbt;
        }

        public void markSyncDirty() {
            this.setDirty();
            this._syncDirty = true;
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.getDataStorage().computeIfAbsent(TYPE);
            }
            return clientSide;
        }
    }
}

