/*
 * Decompiled with CFR 0.152.
 */
package dev.kosmx.playerAnim.impl.animation;

import dev.kosmx.playerAnim.api.PartKey;
import dev.kosmx.playerAnim.api.TransformType;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.core.impl.AnimationProcessor;
import dev.kosmx.playerAnim.core.util.MathHelper;
import dev.kosmx.playerAnim.core.util.Vec3f;
import net.minecraft.client.model.geom.ModelPart;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnimationApplier
extends AnimationProcessor {
    @NotNull
    public static final AnimationApplier EMPTY = new AnimationApplier(null);

    public AnimationApplier(@Nullable IAnimation animation) {
        super(animation);
    }

    public void updatePart(@NotNull PartKey partKey, ModelPart part) {
        Vec3f pos = this.get3DTransform(partKey, TransformType.POSITION, new Vec3f(part.x, part.y, part.z));
        part.x = ((Float)pos.getX()).floatValue();
        part.y = ((Float)pos.getY()).floatValue();
        part.z = ((Float)pos.getZ()).floatValue();
        Vec3f rot = this.get3DTransform(partKey, TransformType.ROTATION, new Vec3f(MathHelper.clampToRadian(part.xRot), MathHelper.clampToRadian(part.yRot), MathHelper.clampToRadian(part.zRot)));
        part.setRotation(((Float)rot.getX()).floatValue(), ((Float)rot.getY()).floatValue(), ((Float)rot.getZ()).floatValue());
        Vec3f scale = this.get3DTransform(partKey, TransformType.SCALE, new Vec3f(part.xScale, part.yScale, part.zScale));
        part.xScale = ((Float)scale.getX()).floatValue();
        part.yScale = ((Float)scale.getY()).floatValue();
        part.zScale = ((Float)scale.getZ()).floatValue();
    }
}

