/*
 * Decompiled with CFR 0.152.
 */
package dev.kosmx.playerAnim.mixin;

import dev.kosmx.playerAnim.api.PartKey;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonConfiguration;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonMode;
import dev.kosmx.playerAnim.impl.IMutableModel;
import dev.kosmx.playerAnim.impl.IPlayerAnimationState;
import dev.kosmx.playerAnim.impl.IPlayerModel;
import dev.kosmx.playerAnim.impl.animation.AnimationApplier;
import java.util.function.Function;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerModel.class}, priority=2000)
public class PlayerModelMixin<T extends LivingEntity>
extends HumanoidModel<PlayerRenderState>
implements IPlayerModel {
    @Shadow
    @Final
    public ModelPart jacket;
    @Shadow
    @Final
    public ModelPart rightSleeve;
    @Shadow
    @Final
    public ModelPart leftSleeve;
    @Shadow
    @Final
    public ModelPart rightPants;
    @Shadow
    @Final
    public ModelPart leftPants;
    @Unique
    private boolean firstPersonNext = false;

    public PlayerModelMixin(ModelPart modelPart, Function<ResourceLocation, RenderType> function) {
        super(modelPart, function);
    }

    @Unique
    private void playerAnimator$setDefaultPivot() {
        this.leftLeg.setPos(1.9f, 12.0f, 0.0f);
        this.rightLeg.setPos(-1.9f, 12.0f, 0.0f);
        this.head.setPos(0.0f, 0.0f, 0.0f);
        this.rightArm.z = 0.0f;
        this.rightArm.x = -5.0f;
        this.leftArm.z = 0.0f;
        this.leftArm.x = 5.0f;
        this.body.xRot = 0.0f;
        this.rightLeg.z = 0.1f;
        this.leftLeg.z = 0.1f;
        this.rightLeg.y = 12.0f;
        this.leftLeg.y = 12.0f;
        this.head.y = 0.0f;
        this.head.zRot = 0.0f;
        this.body.y = 0.0f;
        this.body.x = 0.0f;
        this.body.z = 0.0f;
        this.body.yRot = 0.0f;
        this.body.zRot = 0.0f;
        this.head.xScale = 1.0f;
        this.head.yScale = 1.0f;
        this.head.zScale = 1.0f;
        this.body.xScale = 1.0f;
        this.body.yScale = 1.0f;
        this.body.zScale = 1.0f;
        this.rightArm.xScale = 1.0f;
        this.rightArm.yScale = 1.0f;
        this.rightArm.zScale = 1.0f;
        this.leftArm.xScale = 1.0f;
        this.leftArm.yScale = 1.0f;
        this.leftArm.zScale = 1.0f;
        this.rightLeg.xScale = 1.0f;
        this.rightLeg.yScale = 1.0f;
        this.rightLeg.zScale = 1.0f;
        this.leftLeg.xScale = 1.0f;
        this.leftLeg.yScale = 1.0f;
        this.leftLeg.zScale = 1.0f;
    }

    @Inject(method={"setupAnim(Lnet/minecraft/client/renderer/entity/state/PlayerRenderState;)V"}, at={@At(value="HEAD")})
    private void setDefaultBeforeRender(PlayerRenderState playerRenderState, CallbackInfo ci) {
        this.playerAnimator$setDefaultPivot();
    }

    @Inject(method={"setupAnim(Lnet/minecraft/client/renderer/entity/state/PlayerRenderState;)V"}, at={@At(value="RETURN")})
    private void setupPlayerAnimation(PlayerRenderState playerRenderState, CallbackInfo ci) {
        IPlayerAnimationState state;
        if (!this.firstPersonNext && playerRenderState instanceof IPlayerAnimationState && (state = (IPlayerAnimationState)playerRenderState).playerAnimator$getAnimationApplier().isActive()) {
            AnimationApplier emote = state.playerAnimator$getAnimationApplier();
            ((IMutableModel)((Object)this)).playerAnimator$setAnimation(emote);
            emote.updatePart(PartKey.HEAD, this.head);
            this.hat.copyFrom(this.head);
            emote.updatePart(PartKey.RIGHT_ARM, this.rightArm);
            emote.updatePart(PartKey.LEFT_ARM, this.leftArm);
            emote.updatePart(PartKey.RIGHT_LEG, this.rightLeg);
            emote.updatePart(PartKey.LEFT_LEG, this.leftLeg);
            emote.updatePart(PartKey.TORSO, this.body);
        } else {
            this.firstPersonNext = false;
            ((IMutableModel)((Object)this)).playerAnimator$setAnimation(AnimationApplier.EMPTY);
        }
        if (FirstPersonMode.isFirstPersonPass() && playerRenderState instanceof IPlayerAnimationState && (state = (IPlayerAnimationState)playerRenderState).playerAnimator$isCameraEntity()) {
            FirstPersonConfiguration config = state.playerAnimator$getAnimationApplier().getFirstPersonConfiguration();
            this.playerAnimator$setAllPartsVisible(false);
            boolean showRightArm = config.isShowRightArm();
            boolean showLeftArm = config.isShowLeftArm();
            this.rightArm.visible = showRightArm;
            this.rightSleeve.visible = showRightArm;
            this.leftArm.visible = showLeftArm;
            this.leftSleeve.visible = showLeftArm;
        }
    }

    @Unique
    private void playerAnimator$setAllPartsVisible(boolean visible) {
        this.head.visible = visible;
        this.body.visible = visible;
        this.leftLeg.visible = visible;
        this.rightLeg.visible = visible;
        this.rightArm.visible = visible;
        this.leftArm.visible = visible;
    }

    @Override
    public void playerAnimator_prepForFirstPersonRender() {
        this.firstPersonNext = true;
    }
}

