/*
 * Decompiled with CFR 0.152.
 */
package com.esmods.keepersofthestonestwo;

import com.esmods.keepersofthestonestwo.init.PowerModMobEffects;
import java.util.Random;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;

@EventBusSubscriber
public class AirPassiveSkills {
    private static final Random RANDOM = new Random();

    @SubscribeEvent
    public static void onLivingIncomingDamage(LivingIncomingDamageEvent event) {
        boolean isHighEnough;
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!event.getSource().is(DamageTypes.FALL)) {
            return;
        }
        boolean hasAirMaster = player.hasEffect(PowerModMobEffects.AIR_MASTER);
        boolean bl = isHighEnough = player.getBlockY() >= 96;
        if (hasAirMaster && isHighEnough) {
            float originalDamage = event.getAmount();
            float reducedDamage = originalDamage * 0.25f;
            event.setAmount(reducedDamage);
        }
    }

    @SubscribeEvent
    public static void onPlayerAttack(LivingDamageEvent.Pre event) {
        LivingEntity target = event.getEntity();
        Entity attacker = event.getSource().getEntity();
        if (!(attacker instanceof Player)) {
            return;
        }
        Player player = (Player)attacker;
        if (player.level().isClientSide()) {
            return;
        }
        if (!player.hasEffect(PowerModMobEffects.AIR_MASTER) || player.getBlockY() < 96) {
            return;
        }
        if (target instanceof Player) {
            return;
        }
        if (RANDOM.nextFloat() < 0.15f) {
            double dz;
            double dx = target.getX() - player.getX();
            double horizontalDist = Math.sqrt(dx * dx + (dz = target.getZ() - player.getZ()) * dz);
            if (horizontalDist > 0.01) {
                dx /= horizontalDist;
                dz /= horizontalDist;
            } else {
                dx = RANDOM.nextGaussian();
                double len = Math.sqrt(dx * dx + (dz = RANDOM.nextGaussian()) * dz);
                if (len > 0.0) {
                    dx /= len;
                    dz /= len;
                }
            }
            target.push(dx * 1.5, 0.35, dz * 1.5);
            target.hurtMarked = true;
        }
    }
}

