/*
 * Decompiled with CFR 0.152.
 */
package com.esmods.keepersofthestonestwo;

import com.esmods.keepersofthestonestwo.init.PowerModMobEffects;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;

@EventBusSubscriber
public class BloodPassiveSkills {
    private static final int WITHER_DURATION = 100;

    private static boolean isBloodMasterActive(Player player) {
        float maxHealth;
        if (player.level().isClientSide()) {
            return false;
        }
        if (!player.hasEffect(PowerModMobEffects.BLOOD_MASTER)) {
            return false;
        }
        float health = player.getHealth();
        return health < (maxHealth = player.getMaxHealth()) * 0.5f;
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent.Pre event) {
        LivingEntity target = event.getEntity();
        Entity entity = event.getSource().getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player attacker = (Player)entity;
        if (target.level().isClientSide()) {
            return;
        }
        if (!BloodPassiveSkills.isBloodMasterActive(attacker)) {
            return;
        }
        event.setNewDamage(event.getOriginalDamage() * 1.2f);
        if (attacker.getRandom().nextFloat() < 0.1f) {
            target.addEffect(new MobEffectInstance(MobEffects.WITHER, 100, 1, false, true));
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        float maxHealth;
        float healAmount;
        LivingEntity killed = event.getEntity();
        if (killed.level().isClientSide()) {
            return;
        }
        Entity source = event.getSource().getEntity();
        if (!(source instanceof Player)) {
            return;
        }
        Player killer = (Player)source;
        if (!BloodPassiveSkills.isBloodMasterActive(killer)) {
            return;
        }
        if (killer.getRandom().nextFloat() < 0.5f && (healAmount = (maxHealth = killer.getMaxHealth()) * 0.1f) > 0.0f) {
            killer.heal(healAmount);
        }
    }
}

