/*
 * Decompiled with CFR 0.152.
 */
package com.esmods.keepersofthestonestwo;

import com.esmods.keepersofthestonestwo.init.PowerModMobEffects;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

@EventBusSubscriber
public class ColorsPassiveSkills {
    private static final int BLINDNESS_DURATION = 140;

    private static boolean hasDye(Player player) {
        for (ItemStack stack : player.getInventory().items) {
            if (stack.isEmpty() || !(stack.getItem() instanceof DyeItem)) continue;
            return true;
        }
        ItemStack offhand = player.getOffhandItem();
        return !offhand.isEmpty() && offhand.getItem() instanceof DyeItem;
    }

    private static boolean isActive(Player player) {
        return !player.level().isClientSide() && player.hasEffect(PowerModMobEffects.COLORS_MASTER) && ColorsPassiveSkills.hasDye(player);
    }

    @SubscribeEvent
    public static void onPlayerAttack(LivingDamageEvent.Pre event) {
        Entity entity = event.getSource().getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player attacker = (Player)entity;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = livingEntity;
        if (!ColorsPassiveSkills.isActive(attacker)) {
            return;
        }
        if (attacker.getRandom().nextFloat() < 0.1f) {
            target.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 140, 0, false, true));
        }
    }

    @SubscribeEvent
    public static void onPlayerTakeDamage(LivingDamageEvent.Pre event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (!ColorsPassiveSkills.isActive(player)) {
            return;
        }
        event.setNewDamage(event.getOriginalDamage() * 0.75f);
    }
}

