/*
 * Decompiled with CFR 0.152.
 */
package com.esmods.keepersofthestonestwo;

import com.esmods.keepersofthestonestwo.init.PowerModMobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

@EventBusSubscriber
public class FormPassiveSkills {
    private static boolean hasFormMaster(Player player) {
        return !player.level().isClientSide() && player.hasEffect(PowerModMobEffects.FORM_MASTER);
    }

    @SubscribeEvent
    public static void onPlayerAttack(LivingDamageEvent.Pre event) {
        Entity entity = event.getSource().getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player attacker = (Player)entity;
        if (!FormPassiveSkills.hasFormMaster(attacker)) {
            return;
        }
        if (attacker.hasEffect(PowerModMobEffects.GIGANTIZATION)) {
            event.setNewDamage(event.getOriginalDamage() * 1.5f);
        }
    }

    @SubscribeEvent
    public static void onPlayerTakeDamage(LivingDamageEvent.Pre event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (!FormPassiveSkills.hasFormMaster(player)) {
            return;
        }
        if (player.hasEffect(PowerModMobEffects.MINIATURIZATION)) {
            event.setNewDamage(event.getOriginalDamage() * 0.25f);
        }
    }
}

