/*
 * Decompiled with CFR 0.152.
 */
package com.esmods.keepersofthestonestwo;

import com.esmods.keepersofthestonestwo.init.PowerModMobEffects;
import com.esmods.keepersofthestonestwo.network.PowerModVariables;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

@EventBusSubscriber
public class GoldenDustPassiveSkills {
    private static final int EFFECT_DURATION = 200;
    private static final int SEARCH_RADIUS = 16;

    private static boolean isElementalMasterNearby(Player player) {
        List players = player.level().getEntitiesOfClass(Player.class, player.getBoundingBox().inflate(16.0));
        for (Player other : players) {
            String element;
            if (other == player || (element = ((PowerModVariables.PlayerVariables)other.getData(PowerModVariables.PLAYER_VARIABLES)).element_name_first).equals("0")) continue;
            return true;
        }
        return false;
    }

    private static boolean isActive(Player player) {
        return !player.level().isClientSide() && player.hasEffect(PowerModMobEffects.GOLDEN_DUST_MASTER) && GoldenDustPassiveSkills.isElementalMasterNearby(player);
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent.Pre event) {
        Player attacker;
        Entity entity;
        Player player;
        LivingEntity target = event.getEntity();
        if (target.level().isClientSide()) {
            return;
        }
        if (target instanceof Player && GoldenDustPassiveSkills.isActive(player = (Player)target)) {
            event.setNewDamage(event.getOriginalDamage() * 0.55f);
            if (player.getRandom().nextFloat() < 0.3f) {
                Holder[] effects = new Holder[]{MobEffects.REGENERATION, PowerModMobEffects.STAR_REGENERATION, MobEffects.DAMAGE_BOOST, PowerModMobEffects.DASH};
                Holder chosen = effects[player.getRandom().nextInt(effects.length)];
                int amplifier = 1;
                player.addEffect(new MobEffectInstance(chosen, 200, amplifier, false, true));
            }
        }
        if ((entity = event.getSource().getEntity()) instanceof Player && GoldenDustPassiveSkills.isActive(attacker = (Player)entity)) {
            event.setNewDamage(event.getOriginalDamage() * 1.35f);
        }
    }
}

