/*
 * Decompiled with CFR 0.152.
 */
package com.esmods.keepersofthestonestwo;

import com.esmods.keepersofthestonestwo.init.PowerModMobEffects;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber
public class GravityPassiveSkills {
    private static final int LEVITATION_DURATION = 500;
    private static final int SLOW_FALLING_DURATION = 30;

    private static boolean isActive(Player player) {
        if (player.level().isClientSide()) {
            return false;
        }
        if (!player.hasEffect(PowerModMobEffects.GRAVITY_MASTER)) {
            return false;
        }
        return player.level().canSeeSky(player.blockPosition().above());
    }

    @SubscribeEvent
    public static void onPlayerAttack(LivingDamageEvent.Pre event) {
        Entity entity = event.getSource().getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player attacker = (Player)entity;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = livingEntity;
        if (!GravityPassiveSkills.isActive(attacker)) {
            return;
        }
        if (attacker.getRandom().nextFloat() < 0.1f) {
            target.addEffect(new MobEffectInstance(MobEffects.LEVITATION, 500, 0, false, true));
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player.level().isClientSide()) {
            return;
        }
        if (!GravityPassiveSkills.isActive(player)) {
            return;
        }
        if (!player.hasEffect(MobEffects.SLOW_FALLING)) {
            player.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 30, 0, false, false));
        }
    }
}

