/*
 * Decompiled with CFR 0.152.
 */
package com.esmods.keepersofthestonestwo;

import com.esmods.keepersofthestonestwo.init.PowerModMobEffects;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber
public class IcePassiveSkills {
    private static final Random RANDOM = new Random();
    private static final float COLD_BIOME_THRESHOLD = 0.15f;

    private static boolean isInColdBiome(Player player) {
        Level level = player.level();
        if (level.isClientSide()) {
            return false;
        }
        Biome biome = (Biome)level.getBiome(player.blockPosition()).value();
        return biome.getBaseTemperature() <= 0.15f;
    }

    private static boolean hasIceMasterEffect(Player player) {
        return player.hasEffect(PowerModMobEffects.ICE_MASTER);
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingDamageEvent.Pre event) {
        Player attacker;
        Entity entity = event.getSource().getEntity();
        if (entity instanceof Player && !(attacker = (Player)entity).level().isClientSide() && IcePassiveSkills.hasIceMasterEffect(attacker) && IcePassiveSkills.isInColdBiome(attacker)) {
            LivingEntity target = event.getEntity();
            if (RANDOM.nextFloat() < 0.2f) {
                target.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 200, 2));
                event.setNewDamage(event.getOriginalDamage() * 1.5f);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        int waterLevel;
        BlockPos feetPos;
        Player player = event.getEntity();
        if (player.level().isClientSide() || !IcePassiveSkills.hasIceMasterEffect(player) || !IcePassiveSkills.isInColdBiome(player)) {
            return;
        }
        Level level = player.level();
        BlockState state = level.getBlockState(feetPos = player.blockPosition().below());
        if (state.is(Blocks.WATER) && (waterLevel = ((Integer)state.getValue((Property)BlockStateProperties.LEVEL)).intValue()) == 0 && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.setBlock(feetPos, Blocks.FROSTED_ICE.defaultBlockState(), 3);
        }
    }
}

