/*
 * Decompiled with CFR 0.152.
 */
package com.esmods.keepersofthestonestwo;

import com.esmods.keepersofthestonestwo.init.PowerModMobEffects;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber
public class MagnetPassiveSkills {
    private static final int SEARCH_RADIUS = 16;
    private static final int ITEM_ATTRACT_RADIUS = 16;
    private static final double ATTRACT_SPEED = 0.2;

    private static boolean isActive(Player player) {
        if (player.level().isClientSide()) {
            return false;
        }
        if (!player.hasEffect(PowerModMobEffects.MAGNET_MASTER)) {
            return false;
        }
        BlockPos center = player.blockPosition();
        for (int x = -16; x <= 16; ++x) {
            for (int y = -16; y <= 16; ++y) {
                for (int z = -16; z <= 16; ++z) {
                    BlockPos pos = center.offset(x, y, z);
                    Block block = player.level().getBlockState(pos).getBlock();
                    if (block != Blocks.COPPER_BLOCK && block != Blocks.IRON_BLOCK) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @SubscribeEvent
    public static void onPlayerAttack(LivingDamageEvent.Pre event) {
        Entity entity = event.getSource().getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player attacker = (Player)entity;
        if (!MagnetPassiveSkills.isActive(attacker)) {
            return;
        }
        event.setNewDamage(event.getOriginalDamage() * 1.2f);
        if (attacker.getRandom().nextFloat() < 0.2f) {
            LivingEntity target = event.getEntity();
            Vec3 direction = target.position().subtract(attacker.position()).normalize();
            if (direction.lengthSqr() < 1.0E-6) {
                direction = new Vec3(0.0, 0.0, 1.0);
            }
            if (!target.level().isClientSide() && target instanceof LivingEntity) {
                LivingEntity living = target;
                living.push(direction.x * 1.0, 0.4, direction.z * 1.0);
                living.hurtMarked = true;
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        if (!MagnetPassiveSkills.isActive(player)) {
            return;
        }
        List entities = player.level().getEntitiesOfClass(ItemEntity.class, player.getBoundingBox().inflate(16.0));
        Vec3 playerPos = player.position();
        for (ItemEntity item : entities) {
            Vec3 itemPos;
            Vec3 direction;
            double distance;
            if (item.isRemoved() || item.isNoGravity() || !((distance = (direction = playerPos.subtract(itemPos = item.position())).length()) > 0.5)) continue;
            direction = direction.normalize();
            item.setDeltaMovement(item.getDeltaMovement().add(direction.x * 0.2, direction.y * 0.2 * 0.5, direction.z * 0.2));
            item.hurtMarked = true;
        }
    }
}

