/*
 * Decompiled with CFR 0.152.
 */
package com.esmods.keepersofthestonestwo;

import com.esmods.keepersofthestonestwo.init.PowerModMobEffects;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;

@EventBusSubscriber
public class MetalPassiveSkills {
    private static final Set<Block> METAL_BLOCKS = Set.of(Blocks.IRON_ORE, Blocks.DEEPSLATE_IRON_ORE, Blocks.COPPER_ORE, Blocks.DEEPSLATE_COPPER_ORE, Blocks.GOLD_ORE, Blocks.DEEPSLATE_GOLD_ORE, Blocks.ANCIENT_DEBRIS, Blocks.NETHER_GOLD_ORE, Blocks.RAW_IRON_BLOCK, Blocks.RAW_COPPER_BLOCK, Blocks.RAW_GOLD_BLOCK, Blocks.IRON_BLOCK, Blocks.COPPER_BLOCK, Blocks.GOLD_BLOCK, Blocks.NETHERITE_BLOCK);
    private static final Map<UUID, Boolean> nearMetalCache = new HashMap<UUID, Boolean>();
    private static final Map<UUID, Long> lastCheckTick = new HashMap<UUID, Long>();
    private static final int CHECK_INTERVAL_TICKS = 20;
    private static final Map<UUID, Long> lastCounterAttack = new HashMap<UUID, Long>();

    private static boolean isNearMetalBlocks(Player player) {
        UUID uuid = player.getUUID();
        Level level = player.level();
        if (level.isClientSide()) {
            return false;
        }
        long currentTick = level.getGameTime();
        if (lastCheckTick.getOrDefault(uuid, 0L) + 20L <= currentTick) {
            boolean result = MetalPassiveSkills.checkForMetalBlocks(player);
            nearMetalCache.put(uuid, result);
            lastCheckTick.put(uuid, currentTick);
            return result;
        }
        return nearMetalCache.getOrDefault(uuid, false);
    }

    private static boolean checkForMetalBlocks(Player player) {
        BlockPos center = player.blockPosition();
        Level level = player.level();
        for (int dx = -16; dx <= 16; ++dx) {
            for (int dy = -16; dy <= 16; ++dy) {
                for (int dz = -16; dz <= 16; ++dz) {
                    Block block = level.getBlockState(center.offset(dx, dy, dz)).getBlock();
                    if (!METAL_BLOCKS.contains(block)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @SubscribeEvent
    public static void onIncomingDamage(LivingIncomingDamageEvent event) {
        Player player;
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player && !(player = (Player)entity).level().isClientSide() && player.hasEffect(PowerModMobEffects.METAL_MASTER) && MetalPassiveSkills.isNearMetalBlocks(player)) {
            event.setAmount(event.getAmount() * 0.8f);
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingDamageEvent.Pre event) {
        Player player;
        DamageSource source = event.getSource();
        Entity entity = source.getEntity();
        if (entity instanceof Player && !(player = (Player)entity).level().isClientSide() && player.hasEffect(PowerModMobEffects.METAL_MASTER) && MetalPassiveSkills.isNearMetalBlocks(player)) {
            event.setNewDamage(event.getOriginalDamage() * 1.1f);
        }
    }

    @SubscribeEvent
    public static void onPlayerAttack(AttackEntityEvent event) {
        long last;
        long now;
        Player player = event.getEntity();
        if (player.level().isClientSide() || !(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (player.hasEffect(PowerModMobEffects.METAL_MASTER) && MetalPassiveSkills.isNearMetalBlocks(player) && (now = System.currentTimeMillis()) - (last = lastCounterAttack.getOrDefault(player.getUUID(), 0L).longValue()) >= 60000L && player.getRandom().nextFloat() < 0.15f) {
            serverPlayer.addEffect(new MobEffectInstance(PowerModMobEffects.DASH, 300, 3, false, false));
            lastCounterAttack.put(player.getUUID(), now);
        }
    }
}

