/*
 * Decompiled with CFR 0.152.
 */
package com.esmods.keepersofthestonestwo;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforgespi.language.IModInfo;

@EventBusSubscriber
public class ModVersionManager {
    private static final String PROJECT_ID = "keepers-of-the-stones-2";
    private static final String MINECRAFT_VERSION = ModVersionManager.getMinecraftVersion();
    private static final String CURRENT_VERSION = ModVersionManager.getCurrentVersion();
    private static final Map<VersionType, Integer> VERSION_PRIORITY = Map.of(VersionType.RELEASE, 0, VersionType.RELEASE_CANDIDATE, 1, VersionType.PRE_RELEASE, 2, VersionType.BETA, 3, VersionType.CUSTOM_SUFFIX, 4, VersionType.UNKNOWN, 5);

    public static void checkForUpdates(ServerPlayer player) {
        try {
            List<VersionData> versions = ModVersionManager.fetchVersionsFromModrinth();
            if (versions.isEmpty()) {
                System.out.println("Couldn't get a list of versions.");
                return;
            }
            Version current = new Version(CURRENT_VERSION, ModVersionManager.getVersionType(CURRENT_VERSION));
            Version latest = null;
            for (VersionData data : versions) {
                if (!ModVersionManager.isMinecraftVersionSupported(data.gameVersions)) continue;
                VersionType type = ModVersionManager.getVersionType(data.versionNumber);
                Version version = new Version(data.versionNumber, type);
                if (current.type == VersionType.RELEASE && version.type != VersionType.RELEASE || version.compareTo(current) <= 0 || latest != null && version.compareTo(latest) <= 0) continue;
                latest = version;
            }
            if (latest == null || latest.compareTo(current) <= 0) {
                System.out.println("There are no updates.");
                return;
            }
            String changelog = ModVersionManager.getVersionChangelog(versions, latest.toString());
            ModVersionManager.sendUpdateMessage(player, latest, changelog);
            System.out.println("A newer version has been found: " + String.valueOf(latest));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean isMinecraftVersionSupported(List<String> gameVersions) {
        return gameVersions.contains(MINECRAFT_VERSION);
    }

    private static void sendUpdateMessage(ServerPlayer player, Version latest, String changelog) {
        MutableComponent message = Component.translatable((String)"power.modupdater.new_release").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)65450))).append((Component)Component.literal((String)latest.toString()).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xFFFF55)))).append((Component)Component.translatable((String)"power.modupdater.click_event").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAAAAAA)).withUnderlined(Boolean.valueOf(true)).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://modrinth.com/project/keepers-of-the-stones-2")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)("\nWhat's new:\n" + changelog))))));
        player.sendSystemMessage((Component)message);
    }

    private static String getVersionChangelog(List<VersionData> allVersions, String version) {
        return allVersions.stream().filter(v -> v.versionNumber.equals(version)).filter(v -> ModVersionManager.isMinecraftVersionSupported(v.gameVersions)).map(v -> v.changelog != null ? v.changelog : "").findFirst().orElse("Changelog not available for your Minecraft version.");
    }

    private static List<VersionData> fetchVersionsFromModrinth() throws IOException {
        URL url = new URL("https://api.modrinth.com/v2/project/keepers-of-the-stones-2/version");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        StringBuilder response = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
        }
        return ModVersionManager.parseVersionsFromJson(response.toString());
    }

    private static List<VersionData> parseVersionsFromJson(String json) {
        JsonArray array = JsonParser.parseString((String)json).getAsJsonArray();
        ArrayList<VersionData> result = new ArrayList<VersionData>();
        for (JsonElement element : array) {
            JsonObject obj = element.getAsJsonObject();
            String versionNumber = obj.get("version_number").getAsString();
            String changelog = obj.has("changelog") ? obj.get("changelog").getAsString() : "";
            JsonArray gameVersionsArray = obj.getAsJsonArray("game_versions");
            ArrayList<String> gameVersions = new ArrayList<String>();
            for (JsonElement el : gameVersionsArray) {
                gameVersions.add(el.getAsString());
            }
            result.add(new VersionData(versionNumber, changelog, gameVersions));
        }
        return result;
    }

    private static VersionType getVersionType(String version) {
        if (version == null || version.isEmpty()) {
            return VersionType.UNKNOWN;
        }
        if (Pattern.matches("^\\d+\\.\\d+\\.\\d+$", version)) {
            return VersionType.RELEASE;
        }
        if (Pattern.matches("^\\d+\\.\\d+\\.\\d+-rc\\d+$", version)) {
            return VersionType.RELEASE_CANDIDATE;
        }
        if (Pattern.matches("^\\d+\\.\\d+\\.\\d+-pre\\d+$", version)) {
            return VersionType.PRE_RELEASE;
        }
        if (Pattern.matches("^\\d+\\.\\d+\\.\\d+\\.\\d+$", version)) {
            return VersionType.BETA;
        }
        if (Pattern.matches("^\\d+\\.\\d+\\.\\d+-[a-zA-Z0-9].*$", version)) {
            return VersionType.CUSTOM_SUFFIX;
        }
        return VersionType.UNKNOWN;
    }

    private static String getCurrentVersion() {
        List mods = ModList.get().getMods();
        for (IModInfo mod : mods) {
            if (!mod.getModId().equals("power")) continue;
            return mod.getVersion().toString();
        }
        return "0.0.0";
    }

    private static String getMinecraftVersion() {
        List mods = ModList.get().getMods();
        for (IModInfo mod : mods) {
            if (!mod.getModId().equals("minecraft")) continue;
            return mod.getVersion().toString();
        }
        return "0.0.0";
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ModVersionManager.executeCheckForUpdates((Event)event, (Entity)event.getEntity());
        ModVersionManager.executeBetaWarning((Event)event, (Entity)event.getEntity());
    }

    private static void executeCheckForUpdates(@Nullable Event event, Entity entity) {
        if (entity == null) {
            return;
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            ModVersionManager.checkForUpdates(serverPlayer);
        }
    }

    private static void executeBetaWarning(@Nullable Event event, Entity entity) {
        if (entity == null) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Version current = new Version(CURRENT_VERSION, ModVersionManager.getVersionType(CURRENT_VERSION));
            if (current.getVersionType() != VersionType.RELEASE) {
                player.displayClientMessage((Component)Component.literal((String)Component.translatable((String)"power.modupdater.beta_detect").getString()), false);
            }
        }
    }

    static class Version
    implements Comparable<Version> {
        private final String raw;
        private final VersionType type;

        public Version(String version, VersionType type) {
            this.raw = version;
            this.type = type;
        }

        @Override
        public int compareTo(Version o) {
            int versionComparison = this.compareVersionStrings(this.raw, o.raw);
            if (versionComparison != 0) {
                return versionComparison;
            }
            int priorityThis = VERSION_PRIORITY.getOrDefault((Object)this.type, 999);
            int priorityOther = VERSION_PRIORITY.getOrDefault((Object)o.type, 999);
            return Integer.compare(priorityThis, priorityOther);
        }

        private int compareVersionStrings(String v1, String v2) {
            String base1 = v1.split("-")[0];
            String base2 = v2.split("-")[0];
            int[] parts1 = this.parseVersionParts(base1);
            int[] parts2 = this.parseVersionParts(base2);
            int length = Math.max(parts1.length, parts2.length);
            for (int i = 0; i < length; ++i) {
                int num2;
                int num1 = i < parts1.length ? parts1[i] : 0;
                int n = num2 = i < parts2.length ? parts2[i] : 0;
                if (num1 == num2) continue;
                return Integer.compare(num1, num2);
            }
            return 0;
        }

        private int[] parseVersionParts(String version) {
            String[] parts = version.split("\\.");
            int[] result = new int[parts.length];
            for (int i = 0; i < parts.length; ++i) {
                try {
                    result[i] = Integer.parseInt(parts[i]);
                    continue;
                }
                catch (NumberFormatException ignored) {
                    result[i] = 0;
                }
            }
            return result;
        }

        public VersionType getVersionType() {
            return this.type;
        }

        public String toString() {
            return this.raw;
        }
    }

    static enum VersionType {
        RELEASE,
        PRE_RELEASE,
        RELEASE_CANDIDATE,
        BETA,
        CUSTOM_SUFFIX,
        UNKNOWN;

    }

    record VersionData(String versionNumber, String changelog, List<String> gameVersions) {
    }
}

