/*
 * Decompiled with CFR 0.152.
 */
package com.esmods.keepersofthestonestwo;

import com.esmods.keepersofthestonestwo.init.PowerModMobEffects;
import java.util.List;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber
public class PlaguePassiveSkills {
    private static final int REGEN_DURATION = 100;
    private static final int SEARCH_RADIUS = 16;

    private static boolean isActive(Player player) {
        if (player.level().isClientSide()) {
            return false;
        }
        if (!player.hasEffect(PowerModMobEffects.PLAGUE_MASTER)) {
            return false;
        }
        List entities = player.level().getEntitiesOfClass(LivingEntity.class, player.getBoundingBox().inflate(16.0));
        for (LivingEntity entity : entities) {
            if (!entity.hasEffect(PowerModMobEffects.PLAGUE)) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onPlayerAttack(LivingDamageEvent.Pre event) {
        Entity entity = event.getSource().getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player attacker = (Player)entity;
        if (!PlaguePassiveSkills.isActive(attacker)) {
            return;
        }
        event.setNewDamage(event.getOriginalDamage() * 1.2f);
        if (attacker.getRandom().nextFloat() < 0.1f) {
            attacker.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 100, 0, false, false));
        }
    }

    @SubscribeEvent
    public static void onPlagueApplicable(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (!(player instanceof Player)) {
            return;
        }
        Player player2 = player;
        if (!player2.hasEffect(PowerModMobEffects.PLAGUE_MASTER)) {
            return;
        }
        player2.removeEffect(MobEffects.POISON);
    }
}

