/*
 * Decompiled with CFR 0.152.
 */
package com.esmods.keepersofthestonestwo;

import com.esmods.keepersofthestonestwo.init.PowerModMobEffects;
import net.minecraft.core.Holder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber
public class PlantsPassiveSkills {
    private static boolean isInValidBiome(Player player) {
        Holder biome = player.level().getBiome(player.blockPosition());
        return biome.is(Tags.Biomes.IS_FOREST) || biome.is(Tags.Biomes.IS_PLAINS) || biome.is(Tags.Biomes.IS_TAIGA) || biome.is(Tags.Biomes.IS_SWAMP) || biome.is(Tags.Biomes.IS_JUNGLE) || biome.is(Tags.Biomes.IS_SAVANNA);
    }

    private static boolean isActive(Player player) {
        if (player.level().isClientSide()) {
            return false;
        }
        if (!player.hasEffect(PowerModMobEffects.PLANTS_MASTER)) {
            return false;
        }
        return PlantsPassiveSkills.isInValidBiome(player);
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent.Pre event) {
        Player player;
        Player attacker;
        LivingEntity victim = event.getEntity();
        DamageSource source = event.getSource();
        Entity entity = source.getEntity();
        if (entity instanceof Player && PlantsPassiveSkills.isActive(attacker = (Player)entity)) {
            event.setNewDamage(event.getOriginalDamage() * 1.05f);
        }
        if (victim instanceof Player && PlantsPassiveSkills.isActive(player = (Player)victim)) {
            LivingEntity attacker2;
            LivingEntity livingEntity = attacker2 = source.getDirectEntity() instanceof LivingEntity ? (LivingEntity)source.getDirectEntity() : null;
            if (attacker2 != null && attacker2 != player && player.getRandom().nextFloat() < 0.25f) {
                float reflected = event.getOriginalDamage() * 0.5f;
                attacker2.hurt(player.damageSources().thorns((Entity)player), reflected);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (!PlantsPassiveSkills.isActive(player)) {
            return;
        }
        if ((player.getFoodData().getSaturationLevel() > 0.0f || player.getFoodData().getFoodLevel() >= 9) && player.level().getGameTime() % 20L == 0L && player.getRandom().nextFloat() < 0.1f) {
            player.heal(1.0f);
        }
    }
}

