/*
 * Decompiled with CFR 0.152.
 */
package com.esmods.keepersofthestonestwo;

import com.esmods.keepersofthestonestwo.init.PowerModMobEffects;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber
public class ShockwavePassiveSkills {
    private static final long COMBO_RESET_TIME = 180L;
    private static final Map<UUID, Integer> attackStreak = new HashMap<UUID, Integer>();
    private static final Map<UUID, Long> lastAttackTime = new HashMap<UUID, Long>();

    private static boolean isStandingOnSolidBlock(Player player) {
        BlockPos pos = player.blockPosition().below();
        BlockState state = player.level().getBlockState(pos);
        return !state.isAir() && state.blocksMotion();
    }

    private static boolean isActive(Player player) {
        return !player.level().isClientSide() && player.hasEffect(PowerModMobEffects.SHOCKWAVE_MASTER) && ShockwavePassiveSkills.isStandingOnSolidBlock(player);
    }

    @SubscribeEvent
    public static void onPlayerAttack(LivingDamageEvent.Pre event) {
        Entity entity = event.getSource().getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player attacker = (Player)entity;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = livingEntity;
        if (!ShockwavePassiveSkills.isActive(attacker)) {
            return;
        }
        UUID id = attacker.getUUID();
        long now = attacker.level().getGameTime();
        long last = lastAttackTime.getOrDefault(id, -100L);
        int streak = attackStreak.getOrDefault(id, 0);
        streak = now - last <= 180L ? ++streak : 1;
        lastAttackTime.put(id, now);
        attackStreak.put(id, streak);
        if (streak % 3 == 0) {
            event.setNewDamage(event.getOriginalDamage() * 1.5f);
            Vec3 dir = target.position().subtract(attacker.position()).normalize();
            if (dir.lengthSqr() < 1.0E-6) {
                dir = new Vec3(0.0, 0.0, 1.0);
            }
            target.push(dir.x * 1.2, 0.4, dir.z * 1.2);
            target.hurtMarked = true;
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (!(player instanceof Player)) {
            return;
        }
        Player player2 = player;
        if (!player2.hasEffect(PowerModMobEffects.SHOCKWAVE_MASTER)) {
            return;
        }
        if (!ShockwavePassiveSkills.isStandingOnSolidBlock(player2)) {
            return;
        }
        Vec3 motion = player2.getDeltaMovement();
        player2.setDeltaMovement(motion.x * 0.6, motion.y, motion.z * 0.6);
    }
}

