/*
 * Decompiled with CFR 0.152.
 */
package com.esmods.keepersofthestonestwo;

import com.esmods.keepersofthestonestwo.init.PowerModMobEffects;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

@EventBusSubscriber
public class SoundPassiveSkills {
    private static final Map<Player, Long> lastStunTime = new HashMap<Player, Long>();
    private static final Random RANDOM = new Random();

    private static boolean hasSoundMaster(Player player) {
        return player.hasEffect(PowerModMobEffects.SOUND_MASTER);
    }

    private static boolean isInEnclosedSpace(Player player) {
        if (!(player.level() instanceof ServerLevel)) {
            return false;
        }
        BlockPos center = player.blockPosition();
        int radius = 4;
        int totalBlocks = 0;
        int airBlocks = 0;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos pos = center.offset(x, y, z);
                    BlockState state = player.level().getBlockState(pos);
                    ++totalBlocks;
                    if (!state.isAir() && state.getBlock() != Blocks.CAVE_AIR && state.getBlock() != Blocks.VOID_AIR) continue;
                    ++airBlocks;
                }
            }
        }
        return totalBlocks > 0 && (double)airBlocks / (double)totalBlocks <= 0.5;
    }

    private static boolean isAttackingFromBehind(LivingEntity attacker, LivingEntity target) {
        if (!(attacker instanceof Player) || !(target instanceof Player)) {
            return false;
        }
        double dx = target.getX() - attacker.getX();
        double dz = target.getZ() - attacker.getZ();
        double angleToTarget = Math.toDegrees(Math.atan2(dz, dx)) - 90.0;
        double attackerYaw = attacker.getYRot();
        double diff = Math.abs((attackerYaw - angleToTarget + 180.0) % 360.0 - 180.0);
        return diff > 90.0;
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingDamageEvent.Pre event) {
        Long lastTime;
        Player player;
        LivingEntity attacker = (LivingEntity)event.getSource().getEntity();
        LivingEntity target = event.getEntity();
        if (!(attacker instanceof Player) || !SoundPassiveSkills.hasSoundMaster(player = (Player)attacker)) {
            return;
        }
        if (!SoundPassiveSkills.isInEnclosedSpace(player)) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - (lastTime = lastStunTime.getOrDefault(player, 0L)) >= 20000L && RANDOM.nextFloat() < 0.15f) {
            target.addEffect(new MobEffectInstance(PowerModMobEffects.STUN, 100));
            lastStunTime.put(player, currentTime);
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingDamageEvent.Pre event) {
        ServerPlayer player;
        LivingEntity attacker;
        block7: {
            block6: {
                LivingEntity target = event.getEntity();
                attacker = (LivingEntity)event.getSource().getEntity();
                if (!(target instanceof ServerPlayer)) break block6;
                player = (ServerPlayer)target;
                if (attacker instanceof LivingEntity) break block7;
            }
            return;
        }
        if (!SoundPassiveSkills.hasSoundMaster((Player)player)) {
            return;
        }
        if (!SoundPassiveSkills.isInEnclosedSpace((Player)player)) {
            return;
        }
        if (SoundPassiveSkills.isAttackingFromBehind(attacker, (LivingEntity)player) && RANDOM.nextFloat() < 0.0f && event instanceof ICancellableEvent) {
            ICancellableEvent _cancellable = (ICancellableEvent)event;
            _cancellable.setCanceled(true);
        }
    }
}

